/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.slf4j.LoggerFactory;

public class ChangeTableState
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableId tableId;
    private NamespaceId namespaceId;
    private TableOperation top;

    public ChangeTableState(NamespaceId namespaceId, TableId tableId, TableOperation top) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        this.top = top;
        if (top != TableOperation.ONLINE && top != TableOperation.OFFLINE) {
            throw new IllegalArgumentException(top.toString());
        }
    }

    @Override
    public long isReady(long tid, Master env) throws Exception {
        return Utils.reserveNamespace(env, this.namespaceId, tid, false, true, this.top) + Utils.reserveTable(env, this.tableId, tid, true, true, this.top);
    }

    @Override
    public Repo<Master> call(long tid, Master env) {
        TableState ts = TableState.ONLINE;
        if (this.top == TableOperation.OFFLINE) {
            ts = TableState.OFFLINE;
        }
        env.getTableManager().transitionTableState(this.tableId, ts);
        Utils.unreserveNamespace(env, this.namespaceId, tid, false);
        Utils.unreserveTable(env, this.tableId, tid, true);
        LoggerFactory.getLogger(ChangeTableState.class).debug("Changed table state {} {}", (Object)this.tableId, (Object)ts);
        env.getEventCoordinator().event("Set table state of %s to %s", this.tableId, ts);
        return null;
    }

    @Override
    public void undo(long tid, Master env) {
        Utils.unreserveNamespace(env, this.namespaceId, tid, false);
        Utils.unreserveTable(env, this.tableId, tid, true);
    }
}

