/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.datasource;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.anyline.annotation.Component;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.data.datasource.DataSourceLoader;
import org.anyline.data.datasource.init.AbstractDataSourceLoader;
import org.anyline.data.jdbc.datasource.JDBCDataSourceHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.transaction.TransactionManage;
import org.anyline.data.transaction.init.DefaultTransactionManage;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

@Component(value="anyline.environment.data.datasource.loader.jdbc")
public class JDBCDataSourceLoader
extends AbstractDataSourceLoader
implements DataSourceLoader {
    private final JDBCDataSourceHolder holder = JDBCDataSourceHolder.instance();

    public DataSourceHolder holder() {
        return this.holder;
    }

    public List<String> load() {
        ArrayList<String> list = new ArrayList<String>();
        boolean loadDefault = true;
        if (!ConfigTable.environment().containsBean("anyline.datasource..default")) {
            DataSource datasource = null;
            DataRuntime runtime = null;
            try {
                datasource = (DataSource)ConfigTable.environment().getBean(DataSource.class);
            }
            catch (Exception e) {
                runtime = null;
            }
            if (null != datasource) {
                try {
                    runtime = this.holder().create("default", (Object)datasource, false);
                    loadDefault = false;
                }
                catch (Exception e) {
                    runtime = null;
                    log.error("\u52a0\u8f7dJDBC\u6570\u636e\u6e90 \u5f02\u5e38:", (Throwable)e);
                }
            }
            if (null != runtime) {
                String driver = ConfigTable.environment().string("spring.datasource.,anyline.datasource.", "driver,driver-class,driver-class-name");
                String url = ConfigTable.environment().string("spring.datasource.,anyline.datasource.", "url,jdbc-url");
                runtime.setDriver(driver);
                runtime.setUrl(url);
                if (BasicUtil.isNotEmpty((Object)url)) {
                    runtime.setAdapterKey(DataSourceUtil.parseAdapterKey((String)url));
                } else {
                    String adapterKey = ConfigTable.environment().string("spring.datasource.,anyline.datasource.", "adapter");
                    if (BasicUtil.isNotEmpty((Object)adapterKey)) {
                        runtime.setAdapterKey(adapterKey);
                    }
                }
                TransactionManage.reg((String)"default", (TransactionManage)new DefaultTransactionManage(datasource));
            }
        } else {
            loadDefault = false;
        }
        list.addAll(this.load("spring.datasource", loadDefault));
        list.addAll(this.load("anyline.datasource", loadDefault));
        String prefix = ConfigTable.environment().string("anyline.datasource,spring.datasource", "prefix");
        if (BasicUtil.isNotEmpty((Object)prefix)) {
            list.addAll(this.load(prefix, loadDefault));
        }
        return list;
    }
}

