/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.rest.spring.helper;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.EBean;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.helper.ValidatorHelper;
import org.androidannotations.rest.spring.annotations.Body;
import org.androidannotations.rest.spring.annotations.Delete;
import org.androidannotations.rest.spring.annotations.Field;
import org.androidannotations.rest.spring.annotations.Get;
import org.androidannotations.rest.spring.annotations.Head;
import org.androidannotations.rest.spring.annotations.Options;
import org.androidannotations.rest.spring.annotations.Part;
import org.androidannotations.rest.spring.annotations.Patch;
import org.androidannotations.rest.spring.annotations.Path;
import org.androidannotations.rest.spring.annotations.Post;
import org.androidannotations.rest.spring.annotations.Put;
import org.androidannotations.rest.spring.annotations.Rest;
import org.androidannotations.rest.spring.api.RestClientErrorHandling;
import org.androidannotations.rest.spring.api.RestClientHeaders;
import org.androidannotations.rest.spring.api.RestClientRootUrl;
import org.androidannotations.rest.spring.api.RestClientSupport;
import org.androidannotations.rest.spring.helper.RestAnnotationHelper;

public class RestSpringValidatorHelper
extends ValidatorHelper {
    private static final List<String> VALID_REST_INTERFACES = Arrays.asList(RestClientHeaders.class.getName(), RestClientErrorHandling.class.getName(), RestClientRootUrl.class.getName(), RestClientSupport.class.getName());
    private static final List<Class<? extends Annotation>> REST_ANNOTATION_CLASSES = Arrays.asList(Get.class, Head.class, Options.class, Post.class, Put.class, Patch.class, Delete.class);
    private static final String METHOD_NAME_SET_ROOT_URL = "setRootUrl";
    private static final String METHOD_NAME_SET_AUTHENTICATION = "setAuthentication";
    private static final String METHOD_NAME_SET_BEARER_AUTH = "setBearerAuth";
    private static final String METHOD_NAME_GET_COOKIE = "getCookie";
    private static final String METHOD_NAME_GET_HEADER = "getHeader";
    private static final String METHOD_NAME_GET_ROOT_URL = "getRootUrl";
    private final RestAnnotationHelper restAnnotationHelper;

    public RestSpringValidatorHelper(AndroidAnnotationsEnvironment environment, String target) {
        super(new TargetAnnotationHelper(environment, target));
        this.restAnnotationHelper = new RestAnnotationHelper(environment, target);
    }

    public void doesNotExtendInvalidInterfaces(TypeElement element, ElementValidation valid) {
        if (element.getInterfaces().size() > 0) {
            boolean isValid = true;
            for (TypeMirror typeMirror : element.getInterfaces()) {
                if (VALID_REST_INTERFACES.contains(typeMirror.toString())) continue;
                isValid = false;
                break;
            }
            if (!isValid) {
                valid.addError("%s interfaces can only extend the following interfaces: " + VALID_REST_INTERFACES);
            }
        }
    }

    public void enclosingElementHasRestAnnotation(Element element, ElementValidation valid) {
        String error = "can only be used in an interface annotated with";
        this.enclosingElementHasAnnotation(Rest.class, element, valid, error);
    }

    public void enclosingElementHasOneOfRestMethodAnnotations(Element element, ElementValidation validation) {
        this.enclosingElementHasOneOfAnnotations(element, REST_ANNOTATION_CLASSES, validation);
    }

    public void unannotatedMethodReturnsRestTemplate(TypeElement typeElement, ElementValidation valid) {
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        boolean foundGetRestTemplateMethod = false;
        boolean foundSetRestTemplateMethod = false;
        boolean foundSetAuthenticationMethod = false;
        boolean foundSetBearerAuthMethod = false;
        boolean foundSetRootUrlMethod = false;
        boolean foundGetCookieMethod = false;
        boolean foundGetHeaderMethod = false;
        boolean foundGetRootUrlMethod = false;
        for (Element element : enclosedElements) {
            VariableElement firstParameter;
            List<? extends VariableElement> parameters;
            if (element.getKind() != ElementKind.METHOD) {
                valid.addError(element, "Only methods are allowed in a %s annotated interface");
                continue;
            }
            boolean hasRestAnnotation = false;
            for (Class<? extends Annotation> annotationClass : REST_ANNOTATION_CLASSES) {
                if (element.getAnnotation(annotationClass) == null) continue;
                hasRestAnnotation = true;
                break;
            }
            if (hasRestAnnotation) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            TypeMirror returnType = executableElement.getReturnType();
            String simpleName = executableElement.getSimpleName().toString();
            if (returnType.toString().equals("org.springframework.web.client.RestTemplate")) {
                if (executableElement.getParameters().size() > 0) {
                    valid.addError(element, "The method returning a RestTemplate should not declare any parameter in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                if (foundGetRestTemplateMethod) {
                    valid.addError(element, "Only one method should declare returning a RestTemplate in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                foundGetRestTemplateMethod = true;
                continue;
            }
            if (simpleName.equals(METHOD_NAME_GET_ROOT_URL)) {
                if (!returnType.toString().equals(CanonicalNameConstants.STRING)) {
                    valid.addError(element, "The method getRootUrl must return String on a %s annotated interface");
                }
                if (executableElement.getParameters().size() != 0) {
                    valid.addError(element, "The method getRootUrl cannot have parameters on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                }
                if (!foundGetRootUrlMethod) {
                    foundGetRootUrlMethod = true;
                    continue;
                }
                valid.addError(element, "The can be only one getRootUrl method on a %s annotated interface");
                continue;
            }
            if (returnType.getKind() == TypeKind.VOID) {
                parameters = executableElement.getParameters();
                if (parameters.size() == 1) {
                    firstParameter = parameters.get(0);
                    if (firstParameter.asType().toString().equals("org.springframework.web.client.RestTemplate")) {
                        if (!foundSetRestTemplateMethod) {
                            foundSetRestTemplateMethod = true;
                            continue;
                        }
                        valid.addError(element, "You can only have oneRestTemplate setter method on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                        continue;
                    }
                    if (executableElement.getSimpleName().toString().equals(METHOD_NAME_SET_ROOT_URL) && !foundSetRootUrlMethod) {
                        foundSetRootUrlMethod = true;
                        continue;
                    }
                    if (executableElement.getSimpleName().toString().equals(METHOD_NAME_SET_AUTHENTICATION) && !foundSetAuthenticationMethod) {
                        foundSetAuthenticationMethod = true;
                        continue;
                    }
                    if (executableElement.getSimpleName().toString().equals(METHOD_NAME_SET_BEARER_AUTH) && !foundSetBearerAuthMethod) {
                        foundSetBearerAuthMethod = true;
                        continue;
                    }
                    valid.addError(element, "The method to set a RestTemplate should have only one RestTemplate parameter on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                if (parameters.size() == 2) {
                    firstParameter = parameters.get(0);
                    VariableElement secondParameter = parameters.get(1);
                    if (firstParameter.asType().toString().equals(CanonicalNameConstants.STRING) && secondParameter.asType().toString().equals(CanonicalNameConstants.STRING)) continue;
                    valid.addError(element, "The method to set headers, cookies, or HTTP Basic Auth should have only String parameters on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                valid.addError(element, "The method to set a RestTemplate should have only one RestTemplate parameter on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                continue;
            }
            if (returnType.toString().equals(CanonicalNameConstants.STRING)) {
                parameters = executableElement.getParameters();
                if (parameters.size() == 1) {
                    firstParameter = parameters.get(0);
                    if (firstParameter.asType().toString().equals(CanonicalNameConstants.STRING)) {
                        if (executableElement.getSimpleName().toString().equals(METHOD_NAME_GET_COOKIE) && !foundGetCookieMethod) {
                            foundGetCookieMethod = true;
                            continue;
                        }
                        if (executableElement.getSimpleName().toString().equals(METHOD_NAME_GET_HEADER) && !foundGetHeaderMethod) {
                            foundGetHeaderMethod = true;
                            continue;
                        }
                        valid.addError(element, "Only one getCookie(String) and one getHeader(String) method are allowed on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                        continue;
                    }
                    valid.addError(element, "Only getCookie(String) and getHeader(String) can return a String on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                valid.addError(element, "The only methods that can return a String on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface are getCookie(String) and getHeader(String)");
                continue;
            }
            valid.addError(element, "All methods should be annotated in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface, except the ones that returns or set a RestTemplate");
        }
    }

    public void validateConverters(Element element, ElementValidation valid) {
        TypeMirror httpMessageConverterType = this.annotationHelper.typeElementFromQualifiedName("org.springframework.http.converter.HttpMessageConverter").asType();
        TypeMirror httpMessageConverterTypeErased = this.annotationHelper.getTypeUtils().erasure(httpMessageConverterType);
        List converters = this.annotationHelper.extractAnnotationClassArrayParameter(element, this.annotationHelper.getTarget(), "converters");
        if (converters == null || converters.isEmpty()) {
            valid.addError(element, "At least one converter is required");
            return;
        }
        for (DeclaredType converterType : converters) {
            TypeMirror erasedConverterType = this.annotationHelper.getTypeUtils().erasure(converterType);
            if (this.annotationHelper.isSubtype(erasedConverterType, httpMessageConverterTypeErased)) {
                Element converterElement = converterType.asElement();
                if (converterElement.getKind().isClass()) {
                    if (!this.annotationHelper.isAbstract(converterElement)) {
                        if (converterElement.getAnnotation(EBean.class) == null) {
                            List<ExecutableElement> constructors = ElementFilter.constructorsIn(converterElement.getEnclosedElements());
                            boolean hasPublicWithNoArgumentConstructor = false;
                            for (ExecutableElement constructor : constructors) {
                                if (!this.annotationHelper.isPublic((Element)constructor) || !constructor.getParameters().isEmpty()) continue;
                                hasPublicWithNoArgumentConstructor = true;
                            }
                            if (hasPublicWithNoArgumentConstructor) continue;
                            valid.addError("The converter class must have a public no argument constructor");
                            continue;
                        }
                        this.typeIsValid(EBean.class, converterType, valid);
                        continue;
                    }
                    valid.addError("The converter class must not be abstract");
                    continue;
                }
                valid.addError("The converter class must be a class");
                continue;
            }
            valid.addError("The converter class must be a subtype of org.springframework.http.converter.HttpMessageConverter");
        }
    }

    public void validateInterceptors(Element element, ElementValidation valid) {
        TypeMirror clientHttpRequestInterceptorType = this.annotationHelper.typeElementFromQualifiedName("org.springframework.http.client.ClientHttpRequestInterceptor").asType();
        TypeMirror clientHttpRequestInterceptorTypeErased = this.annotationHelper.getTypeUtils().erasure(clientHttpRequestInterceptorType);
        List interceptors = this.annotationHelper.extractAnnotationClassArrayParameter(element, this.annotationHelper.getTarget(), "interceptors");
        if (interceptors == null) {
            return;
        }
        for (DeclaredType interceptorType : interceptors) {
            TypeMirror erasedInterceptorType = this.annotationHelper.getTypeUtils().erasure(interceptorType);
            if (this.annotationHelper.isSubtype(erasedInterceptorType, clientHttpRequestInterceptorTypeErased)) {
                Element interceptorElement = interceptorType.asElement();
                if (interceptorElement.getKind().isClass()) {
                    if (!this.annotationHelper.isAbstract(interceptorElement)) {
                        if (interceptorElement.getAnnotation(EBean.class) == null) {
                            List<ExecutableElement> constructors = ElementFilter.constructorsIn(interceptorElement.getEnclosedElements());
                            boolean hasPublicWithNoArgumentConstructor = false;
                            for (ExecutableElement constructor : constructors) {
                                if (!this.annotationHelper.isPublic((Element)constructor) || !constructor.getParameters().isEmpty()) continue;
                                hasPublicWithNoArgumentConstructor = true;
                            }
                            if (hasPublicWithNoArgumentConstructor) continue;
                            valid.addError("The interceptor class must have a public no argument constructor or be annotated with @EBean");
                            continue;
                        }
                        this.typeIsValid(EBean.class, interceptorType, valid);
                        continue;
                    }
                    valid.addError("The interceptor class must not be abstract");
                    continue;
                }
                valid.addError("The interceptor class must be a class");
                continue;
            }
            valid.addError("The interceptor class must be a subtype of org.springframework.http.client.ClientHttpRequestInterceptor");
        }
    }

    public void validateRestSimpleParameter(Element element, String requiredClass, String parameterName, ElementValidation validation) {
        TypeMirror requiredType = this.annotationHelper.typeElementFromQualifiedName(requiredClass).asType();
        DeclaredType paramterType = this.annotationHelper.extractAnnotationClassParameter(element, this.annotationHelper.getTarget(), parameterName);
        if (paramterType != null) {
            if (this.annotationHelper.isSubtype((TypeMirror)paramterType, requiredType)) {
                Element parameterElement = paramterType.asElement();
                if (parameterElement.getKind().isClass()) {
                    if (!this.annotationHelper.isAbstract(parameterElement)) {
                        if (parameterElement.getAnnotation(EBean.class) != null) {
                            this.typeIsValid(EBean.class, paramterType, validation);
                            return;
                        }
                        List<ExecutableElement> constructors = ElementFilter.constructorsIn(parameterElement.getEnclosedElements());
                        for (ExecutableElement constructor : constructors) {
                            if (!this.annotationHelper.isPublic((Element)constructor) || !constructor.getParameters().isEmpty()) continue;
                            return;
                        }
                        validation.addError(element, "The " + parameterName + " class must have a public no argument constructor or must be annotated with @EBean");
                    } else {
                        validation.addError(element, "The " + parameterName + " class must not be abstract");
                    }
                } else {
                    validation.addError(element, "The " + parameterName + " class must be a class");
                }
            } else {
                validation.addError(element, "The " + parameterName + " class must be a subtype of " + requiredClass);
            }
        }
    }

    public void validateRequestFactory(Element element, ElementValidation validation) {
        this.validateRestSimpleParameter(element, "org.springframework.http.client.ClientHttpRequestFactory", "requestFactory", validation);
    }

    public void validateResponseErrorHandler(Element element, ElementValidation validation) {
        this.validateRestSimpleParameter(element, "org.springframework.web.client.ResponseErrorHandler", "responseErrorHandler", validation);
    }

    public void throwsOnlyRestClientException(ExecutableElement element, ElementValidation valid) {
        List<? extends TypeMirror> thrownTypes = element.getThrownTypes();
        if (!(thrownTypes.size() <= 0 || thrownTypes.size() <= 1 && thrownTypes.get(0).toString().equals("org.springframework.web.client.RestClientException"))) {
            valid.addError("%s annotated methods can only declare throwing a RestClientException");
        }
    }

    public void urlVariableNamesExistInParameters(ExecutableElement element, Set<String> variableNames, ElementValidation valid) {
        List<? extends VariableElement> parameters = element.getParameters();
        HashSet<String> parametersName = new HashSet<String>();
        for (VariableElement variableElement : parameters) {
            if (variableElement.getAnnotation(Path.class) == null) continue;
            String nameToAdd = this.restAnnotationHelper.getUrlVariableCorrespondingTo(variableElement);
            if (parametersName.contains(nameToAdd)) {
                valid.addError((Element)element, "%s has multiple method parameters which correspond to the same url variable");
                return;
            }
            parametersName.add(nameToAdd);
        }
        String[] cookiesToUrl = this.restAnnotationHelper.requiredUrlCookies(element);
        if (cookiesToUrl != null) {
            Collections.addAll(parametersName, cookiesToUrl);
        }
        for (String variableName : variableNames) {
            if (parametersName.contains(variableName)) continue;
            valid.addError("%s annotated method has an url variable which name could not be found in the method parameters: " + variableName);
            return;
        }
    }

    public void doesNotMixRequestEntityAnnotations(ExecutableElement element, ElementValidation validation) {
        int numberOfRequestEntityFound = 0;
        boolean partFound = false;
        boolean fieldFound = false;
        boolean bodyFound = false;
        for (VariableElement variableElement : element.getParameters()) {
            Body body;
            Field field;
            Part part = variableElement.getAnnotation(Part.class);
            if (part != null && !partFound) {
                partFound = true;
                ++numberOfRequestEntityFound;
            }
            if ((field = variableElement.getAnnotation(Field.class)) != null && !fieldFound) {
                fieldFound = true;
                ++numberOfRequestEntityFound;
            }
            if ((body = variableElement.getAnnotation(Body.class)) == null || bodyFound) continue;
            bodyFound = true;
            ++numberOfRequestEntityFound;
        }
        if (numberOfRequestEntityFound > 1) {
            validation.addError((Element)element, "Only one of @Part, @Field and @Body annotations can be used on the same method's parameters, not both.");
        }
    }

    public void urlVariableNameExistsInEnclosingAnnotation(Element element, ElementValidation validation) {
        String string;
        Set<String> set;
        HashSet<String> validRestMethodAnnotationNames = new HashSet<String>();
        for (Class<? extends Annotation> clazz : REST_ANNOTATION_CLASSES) {
            validRestMethodAnnotationNames.add(clazz.getCanonicalName());
        }
        String url = null;
        for (AnnotationMirror annotationMirror : element.getEnclosingElement().getAnnotationMirrors()) {
            if (!validRestMethodAnnotationNames.contains(annotationMirror.getAnnotationType().toString())) continue;
            url = (String)this.restAnnotationHelper.extractAnnotationParameter(element.getEnclosingElement(), annotationMirror.getAnnotationType().toString(), "value");
            break;
        }
        if (!(set = this.restAnnotationHelper.extractUrlVariableNames(url)).contains(string = this.restAnnotationHelper.getUrlVariableCorrespondingTo((VariableElement)element))) {
            validation.addError(element, "%s annotated parameter is has no corresponding url variable");
        }
    }

    public void hasSpringAndroidJars(ElementValidation valid) {
        Elements elementUtils = this.annotationHelper.getElementUtils();
        if (elementUtils.getTypeElement("org.springframework.web.client.RestTemplate") == null) {
            valid.addError("Could not find the SpringAndroid framework in the classpath, the following class is missing: org.springframework.web.client.RestTemplate");
        }
    }

    public void hasHttpHeadersReturnType(ExecutableElement element, ElementValidation valid) {
        String returnType = element.getReturnType().toString();
        if (!"org.springframework.http.HttpHeaders".equals(returnType)) {
            valid.addError("%s annotated methods can only return a HttpHeaders, not " + returnType);
        }
    }

    public void hasSetOfHttpMethodReturnType(ExecutableElement element, ElementValidation valid) {
        TypeMirror returnType = element.getReturnType();
        String returnTypeString = returnType.toString();
        if (!"java.util.Set<org.springframework.http.HttpMethod>".equals(returnTypeString)) {
            valid.addError("%s annotated methods can only return a Set of HttpMethod, not " + returnTypeString);
        } else {
            DeclaredType declaredType = (DeclaredType)returnType;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.size() != 1) {
                valid.addError("%s annotated methods can only return a parameterized Set (with HttpMethod)");
            } else {
                TypeMirror typeArgument = typeArguments.get(0);
                if (!typeArgument.toString().equals("org.springframework.http.HttpMethod")) {
                    valid.addError("%s annotated methods can only return a parameterized Set of HttpMethod, not " + typeArgument.toString());
                }
            }
        }
    }

    public int numberOfBodyAnnotatedParameter(ExecutableElement element) {
        return this.numberOfElementParameterHasAnnotation(element, Body.class);
    }

    public int numberOfPathAnnotatedParameter(ExecutableElement element) {
        return this.numberOfElementParameterHasAnnotation(element, Path.class);
    }

    public int numberOfRequiresCookieInUrl(ExecutableElement element) {
        String[] cookiesToUrl = this.restAnnotationHelper.requiredUrlCookies(element);
        if (cookiesToUrl == null) {
            return 0;
        }
        return cookiesToUrl.length;
    }

    public int numberOfPartAnnotatedParameter(ExecutableElement element) {
        return this.numberOfElementParameterHasAnnotation(element, Part.class);
    }

    public int numberOfFieldAnnotatedParameter(ExecutableElement element) {
        return this.numberOfElementParameterHasAnnotation(element, Field.class);
    }

    public void doesNotHaveDuplicateFieldAndPartName(ExecutableElement element, ElementValidation validation) {
        if (this.restAnnotationHelper.extractFieldAndPartParameters(element) == null) {
            validation.addError((Element)element, "%s annotated method has multiple form parameters with the same name");
        }
    }

    public void doesNotHaveBodyAnnotatedParameter(ExecutableElement element, ElementValidation validation) {
        if (this.numberOfBodyAnnotatedParameter(element) != 0) {
            validation.addError((Element)element, "%s parameters must not have @Body parameter");
        }
    }

    public void doesNotHavePartAnnotatedParameter(ExecutableElement element, ElementValidation validation) {
        if (this.numberOfPartAnnotatedParameter(element) != 0) {
            validation.addError((Element)element, "%s parameters must not have @Part parameter");
        }
    }

    public void doesNotHaveFieldAnnotatedParameter(ExecutableElement element, ElementValidation validation) {
        if (this.numberOfFieldAnnotatedParameter(element) != 0) {
            validation.addError((Element)element, "%s parameters must not have @Field parameter");
        }
    }

    public void doesNotHaveRequestEntityAnnotatedParameters(ExecutableElement element, ElementValidation validation) {
        this.doesNotHavePartAnnotatedParameter(element, validation);
        this.doesNotHaveFieldAnnotatedParameter(element, validation);
        this.doesNotHaveBodyAnnotatedParameter(element, validation);
    }

    public void doesNotHavePathAnnotation(Element element, ElementValidation validation) {
        this.doesNotHaveAnnotation(element, Path.class, validation);
    }

    public void doesNotHaveFieldAnnotation(Element element, ElementValidation validation) {
        this.doesNotHaveAnnotation(element, Field.class, validation);
    }

    public void doesNotHavePartAnnotation(Element element, ElementValidation validation) {
        this.doesNotHaveAnnotation(element, Part.class, validation);
    }

    public void doesNotHaveBodyAnnotation(Element element, ElementValidation validation) {
        this.doesNotHaveAnnotation(element, Body.class, validation);
    }

    public void restInterfaceHasFormConverter(Element element, ElementValidation validation) {
        Element restInterface = element.getEnclosingElement().getEnclosingElement();
        if (restInterface.getAnnotation(Rest.class) == null) {
            return;
        }
        List converters = this.annotationHelper.extractAnnotationClassArrayParameter(restInterface, Rest.class.getCanonicalName(), "converters");
        boolean formConverterFound = false;
        TypeMirror formConverter = this.annotationHelper.getElementUtils().getTypeElement("org.springframework.http.converter.FormHttpMessageConverter").asType();
        for (DeclaredType converter : converters) {
            if (formConverter == null || !this.annotationHelper.isSubtype((TypeMirror)converter, formConverter)) continue;
            formConverterFound = true;
            break;
        }
        if (!formConverterFound) {
            validation.addError(element, "%s annotated method parameter must be in a @Rest annotated interface which uses at least one org.springframework.http.converter.FormHttpMessageConverter (or subtype)");
        }
    }

    public void elementHasOneOfRestMethodAnnotations(Element element, ElementValidation validation) {
        this.hasOneOfAnnotations(element, element, REST_ANNOTATION_CLASSES, validation);
    }

    public void usesSpringAndroid2(Element element, ElementValidation validation) {
        if (this.environment().getProcessingEnvironment().getElementUtils().getTypeElement("org.springframework.core.ParameterizedTypeReference") == null) {
            validation.addError(element, "To use %s annotated method you must add Spring Android Rest Template 2.0 to your classpath");
        }
    }

    public void hasOneOrZeroBodyParameter(ExecutableElement element, ElementValidation validation) {
        if (validation.isValid() && this.numberOfBodyAnnotatedParameter(element) > 1) {
            validation.addError((Element)element, "%s parameters must not have more than one @Body annotation.");
        }
    }

    public void hasAnnotatedAllParameters(ExecutableElement element, ElementValidation validation) {
        if (!validation.isValid()) {
            return;
        }
        Set<String> urlVariableNames = this.restAnnotationHelper.extractUrlVariableNames(element);
        if (urlVariableNames.size() != this.numberOfPathAnnotatedParameter(element) + this.numberOfRequiresCookieInUrl(element)) {
            validation.addError((Element)element, "%s must have url variables corresponding to the @Path or @RequiresCookieInUrl annotation");
        }
        for (VariableElement variableElement : element.getParameters()) {
            if (this.restAnnotationHelper.hasRestApiMethodParameterAnnotation(variableElement)) continue;
            validation.addError((Element)element, "%s method parameters '" + variableElement + "' must be annotated");
        }
    }
}

