/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.rest.spring.helper;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.rest.spring.annotations.Accept;
import org.androidannotations.rest.spring.annotations.Body;
import org.androidannotations.rest.spring.annotations.Field;
import org.androidannotations.rest.spring.annotations.Header;
import org.androidannotations.rest.spring.annotations.Headers;
import org.androidannotations.rest.spring.annotations.Part;
import org.androidannotations.rest.spring.annotations.Path;
import org.androidannotations.rest.spring.annotations.RequiresAuthentication;
import org.androidannotations.rest.spring.annotations.RequiresCookie;
import org.androidannotations.rest.spring.annotations.RequiresCookieInUrl;
import org.androidannotations.rest.spring.annotations.RequiresHeader;
import org.androidannotations.rest.spring.annotations.SetsCookie;
import org.androidannotations.rest.spring.holder.RestHolder;

public class RestAnnotationHelper
extends TargetAnnotationHelper {
    private APTCodeModelHelper codeModelHelper;
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");

    public RestAnnotationHelper(AndroidAnnotationsEnvironment environment, String annotationName) {
        super(environment, annotationName);
        this.codeModelHelper = new APTCodeModelHelper(environment);
    }

    public Set<String> extractUrlVariableNames(ExecutableElement element) {
        String uriTemplate = (String)this.extractAnnotationValueParameter(element);
        return this.extractUrlVariableNames(uriTemplate);
    }

    public Set<String> extractUrlVariableNames(String uriTemplate) {
        boolean hasValueInAnnotation;
        HashSet<String> variableNames = new HashSet<String>();
        boolean bl = hasValueInAnnotation = uriTemplate != null;
        if (hasValueInAnnotation) {
            Matcher m = NAMES_PATTERN.matcher(uriTemplate);
            while (m.find()) {
                variableNames.add(m.group(1));
            }
        }
        return variableNames;
    }

    public JVar declareUrlVariables(ExecutableElement element, RestHolder holder, JBlock methodBody, SortedMap<String, JVar> methodParams) {
        HashMap<String, String> urlNameToElementName = new HashMap<String, String>();
        for (VariableElement variableElement : element.getParameters()) {
            if (variableElement.getAnnotation(Path.class) == null) continue;
            urlNameToElementName.put(this.getUrlVariableCorrespondingTo(variableElement), variableElement.getSimpleName().toString());
        }
        Set<String> urlVariables = this.extractUrlVariableNames(element);
        String[] stringArray = this.requiredUrlCookies(element);
        if (stringArray != null) {
            for (String cookie : stringArray) {
                urlVariables.add(cookie);
            }
        }
        AbstractJClass hashMapClass = this.getEnvironment().getClasses().HASH_MAP.narrow(new Class[]{String.class, Object.class});
        if (!urlVariables.isEmpty()) {
            JVar hashMapVar = methodBody.decl((AbstractJType)hashMapClass, "urlVariables", (IJExpression)JExpr._new((AbstractJClass)hashMapClass));
            for (String urlVariable : urlVariables) {
                String elementName = (String)urlNameToElementName.get(urlVariable);
                if (elementName != null) {
                    JVar methodParam = (JVar)methodParams.get(elementName);
                    methodBody.invoke((IJExpression)hashMapVar, "put").arg(urlVariable).arg((IJExpression)methodParam);
                    methodParams.remove(elementName);
                    continue;
                }
                JInvocation cookieValue = holder.getAvailableCookiesField().invoke("get").arg((IJExpression)JExpr.lit((String)urlVariable));
                methodBody.invoke((IJExpression)hashMapVar, "put").arg(urlVariable).arg((IJExpression)cookieValue);
            }
            return hashMapVar;
        }
        return null;
    }

    public String acceptedHeaders(ExecutableElement executableElement) {
        Accept acceptAnnotation = executableElement.getAnnotation(Accept.class);
        if (acceptAnnotation == null) {
            acceptAnnotation = executableElement.getEnclosingElement().getAnnotation(Accept.class);
        }
        if (acceptAnnotation != null) {
            return acceptAnnotation.value();
        }
        return null;
    }

    public boolean multipartHeaderRequired(ExecutableElement executableElement) {
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (variableElement.getAnnotation(Part.class) == null) continue;
            return true;
        }
        return false;
    }

    public String[] requiredHeaders(ExecutableElement executableElement) {
        RequiresHeader requiresHeaderAnnotation = executableElement.getAnnotation(RequiresHeader.class);
        if (requiresHeaderAnnotation == null) {
            requiresHeaderAnnotation = executableElement.getEnclosingElement().getAnnotation(RequiresHeader.class);
        }
        if (requiresHeaderAnnotation != null) {
            return requiresHeaderAnnotation.value();
        }
        return null;
    }

    private Map<String, String> getHeadersFromAnnotations(ExecutableElement executableElement) {
        Header header;
        Headers headers = executableElement.getAnnotation(Headers.class);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (headers != null) {
            Header[] headerList;
            for (Header header2 : headerList = headers.value()) {
                headerMap.put(header2.name(), header2.value());
            }
        }
        if ((header = executableElement.getAnnotation(Header.class)) != null) {
            headerMap.put(header.name(), header.value());
        }
        return headerMap;
    }

    public String[] requiredCookies(ExecutableElement executableElement) {
        RequiresCookie cookieAnnotation = executableElement.getAnnotation(RequiresCookie.class);
        if (cookieAnnotation == null) {
            cookieAnnotation = executableElement.getEnclosingElement().getAnnotation(RequiresCookie.class);
        }
        if (cookieAnnotation != null) {
            return cookieAnnotation.value();
        }
        return null;
    }

    public String[] requiredUrlCookies(ExecutableElement executableElement) {
        RequiresCookieInUrl cookieAnnotation = executableElement.getAnnotation(RequiresCookieInUrl.class);
        if (cookieAnnotation == null) {
            cookieAnnotation = executableElement.getEnclosingElement().getAnnotation(RequiresCookieInUrl.class);
        }
        if (cookieAnnotation != null) {
            return cookieAnnotation.value();
        }
        return null;
    }

    public String[] settingCookies(ExecutableElement executableElement) {
        SetsCookie cookieAnnotation = executableElement.getAnnotation(SetsCookie.class);
        if (cookieAnnotation == null) {
            cookieAnnotation = executableElement.getEnclosingElement().getAnnotation(SetsCookie.class);
        }
        if (cookieAnnotation != null) {
            return cookieAnnotation.value();
        }
        return null;
    }

    public boolean requiredAuthentication(ExecutableElement executableElement) {
        RequiresAuthentication basicAuthAnnotation = executableElement.getAnnotation(RequiresAuthentication.class);
        if (basicAuthAnnotation == null) {
            basicAuthAnnotation = executableElement.getEnclosingElement().getAnnotation(RequiresAuthentication.class);
        }
        return basicAuthAnnotation != null;
    }

    public JVar declareHttpHeaders(ExecutableElement executableElement, RestHolder holder, JBlock body) {
        JVar httpHeadersVar = null;
        String mediaType = this.acceptedHeaders(executableElement);
        boolean hasMediaTypeDefined = mediaType != null;
        JInvocation cookies = this.requiredCookies(executableElement);
        boolean requiresCookies = cookies != null && ((String[])cookies).length > 0;
        String[] headers = this.requiredHeaders(executableElement);
        boolean requiresHeaders = headers != null && headers.length > 0;
        boolean requiresAuth = this.requiredAuthentication(executableElement);
        boolean requiresMultipartHeader = this.multipartHeaderRequired(executableElement);
        Map<String, String> headersFromAnnotations = this.getHeadersFromAnnotations(executableElement);
        if (hasMediaTypeDefined || requiresCookies || requiresHeaders || requiresAuth || requiresMultipartHeader || !headersFromAnnotations.isEmpty()) {
            httpHeadersVar = body.decl((AbstractJType)this.getEnvironment().getJClass("org.springframework.http.HttpHeaders"), "httpHeaders", (IJExpression)JExpr._new((AbstractJClass)this.getEnvironment().getJClass("org.springframework.http.HttpHeaders")));
        }
        if (hasMediaTypeDefined) {
            AbstractJClass collectionsClass = this.getEnvironment().getJClass(CanonicalNameConstants.COLLECTIONS);
            AbstractJClass abstractJClass = this.getEnvironment().getJClass("org.springframework.http.MediaType");
            JInvocation mediaTypeListParam = collectionsClass.staticInvoke("singletonList").arg((IJExpression)abstractJClass.staticInvoke("parseMediaType").arg(mediaType));
            body.add((IJStatement)JExpr.invoke((IJExpression)httpHeadersVar, (String)"setAccept").arg((IJExpression)mediaTypeListParam));
        }
        if (headersFromAnnotations != null) {
            for (Map.Entry entry : headersFromAnnotations.entrySet()) {
                body.add((IJStatement)JExpr.invoke((IJExpression)httpHeadersVar, (String)"set").arg((String)entry.getKey()).arg((String)entry.getValue()));
            }
        }
        if (requiresCookies) {
            AbstractJClass stringBuilderClass = this.getEnvironment().getClasses().STRING_BUILDER;
            JVar jVar = body.decl((AbstractJType)stringBuilderClass, "cookiesValue", (IJExpression)JExpr._new((AbstractJClass)stringBuilderClass));
            for (JInvocation cookie : cookies) {
                JInvocation cookieValue = JExpr.invoke((IJExpression)holder.getAvailableCookiesField(), (String)"get").arg((String)cookie);
                JInvocation cookieFormatted = this.getEnvironment().getClasses().STRING.staticInvoke("format").arg(String.format("%s=%%s;", cookie)).arg((IJExpression)cookieValue);
                JInvocation appendCookie = JExpr.invoke((IJExpression)jVar, (String)"append").arg((IJExpression)cookieFormatted);
                body.add((IJStatement)appendCookie);
            }
            JInvocation cookiesToString = jVar.invoke("toString");
            body.add((IJStatement)JExpr.invoke((IJExpression)httpHeadersVar, (String)"set").arg("Cookie").arg((IJExpression)cookiesToString));
        }
        if (requiresMultipartHeader) {
            body.add((IJStatement)JExpr.invoke((IJExpression)httpHeadersVar, (String)"set").arg((IJExpression)JExpr.lit((String)"Content-Type")).arg((IJExpression)this.getEnvironment().getJClass("org.springframework.http.MediaType").staticRef("MULTIPART_FORM_DATA_VALUE")));
        }
        if (requiresHeaders) {
            for (String header : headers) {
                JBlock block = null;
                block = headersFromAnnotations.containsKey(header) ? body._if((IJExpression)JExpr.invoke((IJExpression)holder.getAvailableHeadersField(), (String)"containsKey").arg(header))._then() : body;
                JInvocation headerValue = JExpr.invoke((IJExpression)holder.getAvailableHeadersField(), (String)"get").arg(header);
                block.add((IJStatement)JExpr.invoke((IJExpression)httpHeadersVar, (String)"set").arg(header).arg((IJExpression)headerValue));
            }
        }
        if (requiresAuth) {
            body.add((IJStatement)httpHeadersVar.invoke("setAuthorization").arg((IJExpression)holder.getAuthenticationField()));
        }
        return httpHeadersVar;
    }

    public JVar getEntitySentToServer(ExecutableElement element, SortedMap<String, JVar> params) {
        for (VariableElement variableElement : element.getParameters()) {
            if (variableElement.getAnnotation(Body.class) == null) continue;
            return (JVar)params.get(variableElement.getSimpleName().toString());
        }
        return null;
    }

    public String getUrlVariableCorrespondingTo(VariableElement parameter) {
        return this.extractParameter(parameter, Path.class);
    }

    public IJExpression declareHttpEntity(JBlock body, JVar entitySentToServer, JVar httpHeaders) {
        AbstractJClass entityType = this.getEnvironment().getJClass(Object.class);
        if (entitySentToServer != null && (entityType = entitySentToServer.type()).isPrimitive()) {
            entityType = entityType.boxify();
        }
        AbstractJClass httpEntity = this.getEnvironment().getJClass("org.springframework.http.HttpEntity");
        JNarrowedClass narrowedHttpEntity = httpEntity.narrow((AbstractJType)entityType);
        JInvocation newHttpEntityVarCall = JExpr._new((AbstractJClass)narrowedHttpEntity);
        if (entitySentToServer != null) {
            newHttpEntityVarCall.arg((IJExpression)entitySentToServer);
        }
        if (httpHeaders != null) {
            newHttpEntityVarCall.arg((IJExpression)httpHeaders);
        } else if (entitySentToServer == null) {
            return JExpr._null();
        }
        return body.decl((AbstractJType)narrowedHttpEntity, "requestEntity", (IJExpression)newHttpEntityVarCall);
    }

    public IJExpression getResponseClass(Element element, RestHolder holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        IJExpression responseClassExpr = this.nullCastedToNarrowedClass(holder);
        TypeMirror returnType = executableElement.getReturnType();
        if (returnType.getKind() != TypeKind.VOID) {
            AbstractJClass responseClass;
            if (this.getElementUtils().getTypeElement("org.springframework.core.ParameterizedTypeReference") != null) {
                List<? extends TypeMirror> typeArguments;
                if (returnType.toString().startsWith("org.springframework.http.ResponseEntity") && !(typeArguments = ((DeclaredType)returnType).getTypeArguments()).isEmpty()) {
                    returnType = typeArguments.get(0);
                }
                if (this.checkIfParameterizedTypeReferenceShouldBeUsed(returnType)) {
                    return this.createParameterizedTypeReferenceAnonymousSubclassInstance(returnType);
                }
            }
            if ((responseClass = this.retrieveResponseClass(returnType, holder)) != null) {
                responseClassExpr = responseClass.dotclass();
            }
        }
        return responseClassExpr;
    }

    private boolean checkIfParameterizedTypeReferenceShouldBeUsed(TypeMirror returnType) {
        switch (returnType.getKind()) {
            case DECLARED: {
                return !((DeclaredType)returnType).getTypeArguments().isEmpty();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)returnType;
                TypeMirror componentType = arrayType.getComponentType();
                return this.checkIfParameterizedTypeReferenceShouldBeUsed(componentType);
            }
        }
        return false;
    }

    public IJExpression createParameterizedTypeReferenceAnonymousSubclassInstance(TypeMirror returnType) {
        JNarrowedClass narrowedTypeReference = this.getEnvironment().getJClass("org.springframework.core.ParameterizedTypeReference").narrow(this.codeModelHelper.typeMirrorToJClass(returnType));
        JAnonymousClass anonymousClass = this.getEnvironment().getCodeModel().anonymousClass((AbstractJClass)narrowedTypeReference);
        return JExpr._new((AbstractJClass)anonymousClass);
    }

    public AbstractJClass retrieveResponseClass(TypeMirror returnType, RestHolder holder) {
        DeclaredType declaredReturnType;
        String returnTypeString = returnType.toString();
        AbstractJClass responseClass = returnTypeString.startsWith("org.springframework.http.ResponseEntity") ? ((declaredReturnType = (DeclaredType)returnType).getTypeArguments().size() > 0 ? this.resolveResponseClass(declaredReturnType.getTypeArguments().get(0), holder, false) : this.getEnvironment().getJClass("org.springframework.http.ResponseEntity")) : this.resolveResponseClass(returnType, holder, true);
        return responseClass;
    }

    private AbstractJClass resolveResponseClass(TypeMirror expectedType, RestHolder holder, boolean useTypeReference) {
        if (expectedType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)expectedType;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.isEmpty()) {
                return this.codeModelHelper.typeMirrorToJClass((TypeMirror)declaredType);
            }
            TypeElement declaredElement = (TypeElement)declaredType.asElement();
            if (useTypeReference && this.getElementUtils().getTypeElement("org.springframework.core.ParameterizedTypeReference") != null) {
                return this.codeModelHelper.typeMirrorToJClass((TypeMirror)declaredType);
            }
            AbstractJClass baseClass = this.codeModelHelper.typeMirrorToJClass((TypeMirror)declaredType).erasure();
            AbstractJClass decoratedExpectedClass = this.retrieveDecoratedResponseClass(declaredType, declaredElement, holder);
            if (decoratedExpectedClass == null) {
                decoratedExpectedClass = baseClass;
            }
            return decoratedExpectedClass;
        }
        if (expectedType.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)expectedType;
            TypeMirror componentType = arrayType.getComponentType();
            return this.resolveResponseClass(componentType, holder, false).array();
        }
        return this.codeModelHelper.typeMirrorToJClass(expectedType);
    }

    private AbstractJClass retrieveDecoratedResponseClass(DeclaredType declaredType, TypeElement typeElement, RestHolder holder) {
        String classTypeBaseName = typeElement.toString();
        String decoratedClassName = null;
        if (typeElement.getKind() == ElementKind.INTERFACE) {
            if (classTypeBaseName.equals(CanonicalNameConstants.MAP)) {
                decoratedClassName = LinkedHashMap.class.getCanonicalName();
            } else if (classTypeBaseName.equals(CanonicalNameConstants.SET)) {
                decoratedClassName = TreeSet.class.getCanonicalName();
            } else if (classTypeBaseName.equals(CanonicalNameConstants.LIST)) {
                decoratedClassName = ArrayList.class.getCanonicalName();
            } else if (classTypeBaseName.equals(CanonicalNameConstants.COLLECTION)) {
                decoratedClassName = ArrayList.class.getCanonicalName();
            }
        } else {
            decoratedClassName = typeElement.getQualifiedName().toString();
        }
        if (decoratedClassName != null) {
            String decoratedClassNameSuffix = "";
            AbstractJClass decoratedSuperClass = this.getEnvironment().getJClass(decoratedClassName);
            Iterator<? extends TypeMirror> iterator = declaredType.getTypeArguments().iterator();
            while (iterator.hasNext()) {
                TypeMirror typeArgument;
                TypeMirror actualTypeArgument = typeArgument = iterator.next();
                if (typeArgument instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)typeArgument;
                    if (wildcardType.getExtendsBound() != null) {
                        actualTypeArgument = wildcardType.getExtendsBound();
                    } else if (wildcardType.getSuperBound() != null) {
                        actualTypeArgument = wildcardType.getSuperBound();
                    }
                }
                AbstractJClass narrowJClass = this.codeModelHelper.typeMirrorToJClass(actualTypeArgument);
                decoratedSuperClass = decoratedSuperClass.narrow(narrowJClass);
                decoratedClassNameSuffix = decoratedClassNameSuffix + this.plainName(narrowJClass);
            }
            String decoratedFinalClassName = classTypeBaseName + "_" + decoratedClassNameSuffix;
            decoratedFinalClassName = decoratedFinalClassName.replaceAll("\\[\\]", "s");
            String packageName = holder.getGeneratedClass()._package().name();
            decoratedFinalClassName = packageName + "." + decoratedFinalClassName;
            JDefinedClass decoratedJClass = this.getEnvironment().getDefinedClass(decoratedFinalClassName);
            decoratedJClass._extends(decoratedSuperClass);
            return decoratedJClass;
        }
        TypeMirror enclosingSuperJClass = typeElement.getSuperclass();
        if (enclosingSuperJClass != null && enclosingSuperJClass.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredEnclosingSuperJClass = (DeclaredType)enclosingSuperJClass;
            return this.retrieveDecoratedResponseClass(declaredType, (TypeElement)declaredEnclosingSuperJClass.asElement(), holder);
        }
        return null;
    }

    protected String plainName(AbstractJClass jClass) {
        String plainName = jClass.erasure().name();
        List typeParameters = jClass.getTypeParameters();
        if (typeParameters.size() > 0) {
            plainName = plainName + "_";
            for (AbstractJClass typeParameter : typeParameters) {
                plainName = plainName + this.plainName(typeParameter);
            }
        }
        return plainName;
    }

    public IJExpression nullCastedToNarrowedClass(RestHolder holder) {
        return JExpr.cast((AbstractJType)this.getEnvironment().getJClass(Class.class).narrow(this.getEnvironment().getJClass(Void.class)), (IJExpression)JExpr._null());
    }

    public Map<String, String> extractFieldAndPartParameters(ExecutableElement element) {
        HashMap<String, String> postParameterNameToElementName = new HashMap<String, String>();
        for (VariableElement variableElement : element.getParameters()) {
            String parameterName = null;
            if (variableElement.getAnnotation(Field.class) != null) {
                parameterName = this.extractParameter(variableElement, Field.class);
            } else if (variableElement.getAnnotation(Part.class) != null) {
                parameterName = this.extractParameter(variableElement, Part.class);
            }
            if (parameterName == null) continue;
            if (postParameterNameToElementName.containsKey(parameterName)) {
                return null;
            }
            postParameterNameToElementName.put(parameterName, variableElement.getSimpleName().toString());
        }
        return postParameterNameToElementName;
    }

    private String extractParameter(VariableElement parameter, Class<? extends Annotation> clazz) {
        String value = (String)this.extractAnnotationParameter(parameter, clazz.getCanonicalName(), "value");
        return !"".equals(value) ? value : parameter.getSimpleName().toString();
    }

    public boolean hasRestApiMethodParameterAnnotation(VariableElement variableElement) {
        return this.hasOneOfClassAnnotations(variableElement, Arrays.asList(Field.class, Part.class, Body.class, Path.class));
    }
}

