/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.otto.handler;

import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.JMethod;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.GeneratedClassHolder;

public abstract class AbstractOttoHandler
extends BaseAnnotationHandler<EComponentHolder> {
    public AbstractOttoHandler(String target, AndroidAnnotationsEnvironment environment) {
        super(target, environment);
    }

    public void validate(Element element, ElementValidation valid) {
        if (!this.annotationHelper.enclosingElementHasEnhancedComponentAnnotation(element)) {
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validateReturnType(executableElement, valid);
        this.validatorHelper.isPublic(element, valid);
        this.validatorHelper.doesntThrowException((Element)executableElement, valid);
        this.validatorHelper.isNotFinal(element, valid);
        this.getParamValidator().validate(executableElement, valid);
    }

    protected abstract ValidatorParameterHelper.Validator getParamValidator();

    protected abstract void validateReturnType(ExecutableElement var1, ElementValidation var2);

    public void process(Element element, EComponentHolder holder) throws Exception {
        if (!this.annotationHelper.enclosingElementHasEnhancedComponentAnnotation(element)) {
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        JMethod method = this.codeModelHelper.overrideAnnotatedMethod(executableElement, (GeneratedClassHolder)holder);
        this.addOttoAnnotation(executableElement, method);
    }

    private void addOttoAnnotation(ExecutableElement element, JMethod method) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(this.getTarget())) continue;
            this.codeModelHelper.copyAnnotation((IJAnnotatable)method, annotationMirror);
            break;
        }
    }
}

