/*
 * Decompiled with CFR 0.152.
 */
package org.aim42.htmlsanitycheck.check;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.SoftReference;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.aim42.htmlsanitycheck.Configuration;
import org.aim42.htmlsanitycheck.check.Checker;
import org.aim42.htmlsanitycheck.collect.Finding;
import org.aim42.htmlsanitycheck.collect.SingleCheckResults;
import org.aim42.htmlsanitycheck.html.HtmlElement;
import org.aim42.htmlsanitycheck.html.HtmlPage;
import org.aim42.inet.NetUtil;
import org.aim42.net.TrustAllCertificates;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class BrokenHttpLinksChecker
extends Checker {
    private List<String> hrefList;
    private Set<HtmlElement> hrefSet;
    private final Collection<Integer> successCodes;
    private final Collection<Integer> warningCodes;
    private final Collection<Integer> errorCodes;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public BrokenHttpLinksChecker(Configuration pConfig) {
        CallSite[] callSiteArray = BrokenHttpLinksChecker.$getCallSiteArray();
        super(pConfig);
        Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), callSiteArray[2].callGetProperty(Configuration.class));
        this.successCodes = (Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class);
        Object object2 = callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), callSiteArray[5].callGetProperty(Configuration.class));
        this.warningCodes = (Collection)ScriptBytecodeAdapter.castToType((Object)object2, Collection.class);
        Object object3 = callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), callSiteArray[8].callGetProperty(Configuration.class));
        this.errorCodes = (Collection)ScriptBytecodeAdapter.castToType((Object)object3, Collection.class);
    }

    @Override
    protected void initCheckingResultsDescription() {
        CallSite[] callSiteArray = BrokenHttpLinksChecker.$getCallSiteArray();
        String string = "External Links Check";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, BrokenHttpLinksChecker.class, (GroovyObject)callSiteArray[9].callGroovyObjectGetProperty((Object)this), (String)"whatIsChecked");
        String string2 = "anchor href attribute";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, BrokenHttpLinksChecker.class, (GroovyObject)callSiteArray[10].callGroovyObjectGetProperty((Object)this), (String)"sourceItemName");
        String string3 = "broken external link";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string3, BrokenHttpLinksChecker.class, (GroovyObject)callSiteArray[11].callGroovyObjectGetProperty((Object)this), (String)"targetItemName");
    }

    @Override
    protected SingleCheckResults check(HtmlPage pageToCheck) {
        CallSite[] callSiteArray = BrokenHttpLinksChecker.$getCallSiteArray();
        Object object = callSiteArray[12].call((Object)pageToCheck);
        this.hrefSet = (Set)ScriptBytecodeAdapter.castToType((Object)object, Set.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[13].callCurrent((GroovyObject)this);
        } else {
            this.addWarningIfNoInternetConnection();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[14].callCurrent((GroovyObject)this);
        } else {
            this.checkAllHttpLinks();
        }
        return (SingleCheckResults)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].callGroovyObjectGetProperty((Object)this), SingleCheckResults.class);
    }

    private void addWarningIfNoInternetConnection() {
        CallSite[] callSiteArray = BrokenHttpLinksChecker.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[16].call(NetUtil.class), (Object)false)) {
            String string = "There seems to be a general problem with internet connectivity, all other checks for http/https links might yield incorrect results!";
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, BrokenHttpLinksChecker.class, (GroovyObject)callSiteArray[17].callGroovyObjectGetProperty((Object)this), (String)"generalRemark");
        }
    }

    private void checkAllHttpLinks() {
        CallSite[] callSiteArray = BrokenHttpLinksChecker.$getCallSiteArray();
        public final class _checkAllHttpLinks_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _checkAllHttpLinks_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _checkAllHttpLinks_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object href) {
                CallSite[] callSiteArray = _checkAllHttpLinks_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, href);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkAllHttpLinks_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doubleCheckSingleHttpLink";
                return new CallSiteArray(_checkAllHttpLinks_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _checkAllHttpLinks_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[18].call(this.hrefSet, (Object)new _checkAllHttpLinks_closure1(this, this));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doubleCheckSingleHttpLink(String href) {
        var2_2 = BrokenHttpLinksChecker.$getCallSiteArray();
        problem = null;
        var2_2[19].call(var2_2[20].callGroovyObjectGetProperty((Object)this));
        try {
            url = (URL)ScriptBytecodeAdapter.castToType((Object)var2_2[21].callConstructor(URL.class, (Object)href), URL.class);
            if (!BrokenHttpLinksChecker.__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) {
                this.checkIfLocalhostURL(url, href);
            } else {
                var2_2[22].callCurrent((GroovyObject)this, (Object)url, (Object)href);
            }
            if (!BrokenHttpLinksChecker.__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) {
                this.checkIfIPAddress(url, href);
            } else {
                var2_2[23].callCurrent((GroovyObject)this, (Object)url, (Object)href);
            }
            try {
                firstConnection = null;
                if (!BrokenHttpLinksChecker.__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) {
                    firstConnection = var7_7 = this.getNewURLConnection(url);
                } else {
                    var6_6 = var2_2[24].callCurrent((GroovyObject)this, (Object)url);
                    firstConnection = (HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)var6_6, HttpURLConnection.class);
                }
                var2_2[25].call((Object)firstConnection);
                responseCode = DefaultTypeTransformation.intUnbox((Object)var2_2[26].call((Object)firstConnection));
                if (ScriptBytecodeAdapter.isCase((Object)responseCode, this.successCodes)) {
                    return;
                }
            }
            catch (Exception UnknownHostException) {
                unknownHostFinding = (Finding)ScriptBytecodeAdapter.castToType((Object)var2_2[44].callConstructor(Finding.class, (Object)new GStringImpl(new Object[]{href}, new String[]{"Unknown host with href=", ""})), Finding.class);
                var2_2[45].call(var2_2[46].callGroovyObjectGetProperty((Object)this), (Object)unknownHostFinding);
                return;
            }
            catch (InterruptedIOException exception) {
                someException = (Finding)ScriptBytecodeAdapter.castToType((Object)var2_2[47].callConstructor(Finding.class, (Object)new GStringImpl(new Object[]{var2_2[48].call((Object)exception), href}, new String[]{"exception ", " with href=", ""})), Finding.class);
                var2_2[49].call(var2_2[50].callGroovyObjectGetProperty((Object)this), (Object)someException);
                return;
            }
            catch (ConnectException exception) {
                someException = (Finding)ScriptBytecodeAdapter.castToType((Object)var2_2[51].callConstructor(Finding.class, (Object)new GStringImpl(new Object[]{var2_2[52].call((Object)exception), href}, new String[]{"exception ", " with href=", ""})), Finding.class);
                var2_2[53].call(var2_2[54].callGroovyObjectGetProperty((Object)this), (Object)someException);
                return;
            }
            catch (IOException exception) {
                someException = (Finding)ScriptBytecodeAdapter.castToType((Object)var2_2[55].callConstructor(Finding.class, (Object)new GStringImpl(new Object[]{var2_2[56].call((Object)exception), href}, new String[]{"exception ", " with href=", ""})), Finding.class);
                var2_2[57].call(var2_2[58].callGroovyObjectGetProperty((Object)this), (Object)someException);
                return;
            }
            catch (Throwable var28_28) {
                throw var28_28;
            }
        }
        catch (MalformedURLException exception) {
            malformedURLFinding = (Finding)ScriptBytecodeAdapter.castToType((Object)var2_2[59].callConstructor(Finding.class, (Object)new GStringImpl(new Object[]{href}, new String[]{"malformed URL exception with href=", ""})), Finding.class);
            var2_2[60].call(var2_2[61].callGroovyObjectGetProperty((Object)this), (Object)malformedURLFinding);
            return;
        }
        catch (Throwable var31_31) {
            throw var31_31;
        }
        {
            block28: {
                if (!ScriptBytecodeAdapter.isCase((Object)responseCode, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{301, 302, 303, 307, 308}))) break block28;
                newLocation = null;
                if (DefaultTypeTransformation.booleanUnbox((Object)var2_2[27].callGetProperty(var2_2[28].callGetProperty((Object)firstConnection)))) {
                    var10_10 = var2_2[29].call(var2_2[30].callGetProperty(var2_2[31].callGetProperty((Object)firstConnection)));
                    newLocation = ShortTypeHandling.castToString((Object)var10_10);
                    var11_11 = new GStringImpl(new Object[]{href, responseCode, newLocation}, new String[]{"Warning: ", " returned statuscode ", ", new location: ", ""});
                    problem = ShortTypeHandling.castToString((Object)var11_11);
                    var2_2[32].call(var2_2[33].callGroovyObjectGetProperty((Object)this), var2_2[34].callConstructor(Finding.class, (Object)problem));
                }
                ** GOTO lbl120
            }
            secondConnection = null;
            if (!BrokenHttpLinksChecker.__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) {
                secondConnection = var14_14 = this.getNewURLConnection(url);
            } else {
                var13_13 = var2_2[35].callCurrent((GroovyObject)this, (Object)url);
                secondConnection = (HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)var13_13, HttpURLConnection.class);
            }
            var2_2[36].call((Object)secondConnection, (Object)"GET");
            finalResponseCode = DefaultTypeTransformation.intUnbox((Object)var2_2[37].call((Object)secondConnection));
            var2_2[38].call((Object)secondConnection);
            var16_16 = finalResponseCode;
            if (!ScriptBytecodeAdapter.isCase((Object)var16_16, this.successCodes)) ** GOTO lbl-1000
        }
        return;
lbl-1000:
        // 1 sources

        {
            if (!ScriptBytecodeAdapter.isCase((Object)var16_16, this.warningCodes)) ** GOTO lbl-1000
            problem = var17_17 = "Warning:";
            ** GOTO lbl116
        }
lbl-1000:
        // 1 sources

        {
            problem = ScriptBytecodeAdapter.isCase((Object)var16_16, this.errorCodes) ? (var18_18 = "Error:") : (var19_19 = "Error: Unknown or unclassified response code:");
lbl116:
            // 2 sources

            problem = ShortTypeHandling.castToString((Object)var2_2[39].call((Object)problem, (Object)new GStringImpl(new Object[]{href, responseCode}, new String[]{" ", " returned statuscode ", "."})));
            var2_2[40].call(var2_2[41].callGroovyObjectGetProperty((Object)this), var2_2[42].callConstructor(Finding.class, (Object)problem));
lbl120:
            // 2 sources

            var2_2[43].call((Object)firstConnection);
            return;
        }
    }

    private HttpURLConnection getNewURLConnection(URL url) {
        CallSite[] callSiteArray = BrokenHttpLinksChecker.$getCallSiteArray();
        callSiteArray[62].call(TrustAllCertificates.class);
        HttpURLConnection connection = (HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].call((Object)url), HttpURLConnection.class);
        callSiteArray[64].call((Object)connection, (Object)"HEAD");
        callSiteArray[65].call((Object)connection, callSiteArray[66].callSafe(callSiteArray[67].callGroovyObjectGetProperty((Object)this), callSiteArray[68].callGetProperty(Configuration.class)));
        callSiteArray[69].call((Object)connection, (Object)"Referer", (Object)"https://aim42.org");
        callSiteArray[70].call((Object)connection, (Object)"User-Agent", (Object)"Mozilla/5.0 (X11; Linux i686; rv:10.0) Gecko/20100101 Firefox/10.0");
        return connection;
    }

    private void checkIfIPAddress(URL url, String href) {
        CallSite[] callSiteArray = BrokenHttpLinksChecker.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].call(callSiteArray[72].callGroovyObjectGetProperty((Object)this), callSiteArray[73].callGetProperty(Configuration.class)))) {
            String host = ShortTypeHandling.castToString((Object)callSiteArray[74].call((Object)url));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[75].call((Object)host, (Object)"\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}"))) {
                Finding localhostWarning = (Finding)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].callConstructor(Finding.class, (Object)new GStringImpl(new Object[]{href}, new String[]{"Warning: numerical urls (ip address) indicates suspicious environment dependency: href=", ""})), Finding.class);
                callSiteArray[77].call(callSiteArray[78].callGroovyObjectGetProperty((Object)this), (Object)localhostWarning);
            }
        }
    }

    private void checkIfLocalhostURL(URL url, String href) {
        CallSite[] callSiteArray = BrokenHttpLinksChecker.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[79].call(callSiteArray[80].callGroovyObjectGetProperty((Object)this), callSiteArray[81].callGetProperty(Configuration.class)))) {
            String host = ShortTypeHandling.castToString((Object)callSiteArray[82].call((Object)url));
            if (ScriptBytecodeAdapter.compareEqual((Object)host, (Object)"localhost") || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[83].call((Object)host, (Object)"127.0.0"))) {
                Finding localhostWarning = (Finding)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].callConstructor(Finding.class, (Object)new GStringImpl(new Object[]{href}, new String[]{"Warning: localhost urls indicates suspicious environment dependency: href=", ""})), Finding.class);
                callSiteArray[85].call(callSiteArray[86].callGroovyObjectGetProperty((Object)this), (Object)localhostWarning);
            }
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BrokenHttpLinksChecker.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getConfigItemByName";
        stringArray[1] = "myConfig";
        stringArray[2] = "ITEM_NAME_httpSuccessCodes";
        stringArray[3] = "getConfigItemByName";
        stringArray[4] = "myConfig";
        stringArray[5] = "ITEM_NAME_httpWarningCodes";
        stringArray[6] = "getConfigItemByName";
        stringArray[7] = "myConfig";
        stringArray[8] = "ITEM_NAME_httpErrorCodes";
        stringArray[9] = "checkingResults";
        stringArray[10] = "checkingResults";
        stringArray[11] = "checkingResults";
        stringArray[12] = "getAllHttpHrefStringsAsSet";
        stringArray[13] = "addWarningIfNoInternetConnection";
        stringArray[14] = "checkAllHttpLinks";
        stringArray[15] = "checkingResults";
        stringArray[16] = "isInternetConnectionAvailable";
        stringArray[17] = "checkingResults";
        stringArray[18] = "each";
        stringArray[19] = "incNrOfChecks";
        stringArray[20] = "checkingResults";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "checkIfLocalhostURL";
        stringArray[23] = "checkIfIPAddress";
        stringArray[24] = "getNewURLConnection";
        stringArray[25] = "connect";
        stringArray[26] = "getResponseCode";
        stringArray[27] = "Location";
        stringArray[28] = "headerFields";
        stringArray[29] = "first";
        stringArray[30] = "Location";
        stringArray[31] = "headerFields";
        stringArray[32] = "addFinding";
        stringArray[33] = "checkingResults";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "getNewURLConnection";
        stringArray[36] = "setRequestMethod";
        stringArray[37] = "getResponseCode";
        stringArray[38] = "disconnect";
        stringArray[39] = "plus";
        stringArray[40] = "addFinding";
        stringArray[41] = "checkingResults";
        stringArray[42] = "<$constructor$>";
        stringArray[43] = "disconnect";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "addFinding";
        stringArray[46] = "checkingResults";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "toString";
        stringArray[49] = "addFinding";
        stringArray[50] = "checkingResults";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "toString";
        stringArray[53] = "addFinding";
        stringArray[54] = "checkingResults";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "toString";
        stringArray[57] = "addFinding";
        stringArray[58] = "checkingResults";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "addFinding";
        stringArray[61] = "checkingResults";
        stringArray[62] = "install";
        stringArray[63] = "openConnection";
        stringArray[64] = "setRequestMethod";
        stringArray[65] = "setConnectTimeout";
        stringArray[66] = "getConfigItemByName";
        stringArray[67] = "myConfig";
        stringArray[68] = "ITEM_NAME_httpConnectionTimeout";
        stringArray[69] = "setRequestProperty";
        stringArray[70] = "setRequestProperty";
        stringArray[71] = "getConfigItemByName";
        stringArray[72] = "myConfig";
        stringArray[73] = "ITEM_NAME_ignoreIPAddresses";
        stringArray[74] = "getHost";
        stringArray[75] = "matches";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "addFinding";
        stringArray[78] = "checkingResults";
        stringArray[79] = "getConfigItemByName";
        stringArray[80] = "myConfig";
        stringArray[81] = "ITEM_NAME_ignoreLocalhost";
        stringArray[82] = "getHost";
        stringArray[83] = "startsWith";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "addFinding";
        stringArray[86] = "checkingResults";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[87];
        BrokenHttpLinksChecker.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(BrokenHttpLinksChecker.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = BrokenHttpLinksChecker.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

