/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.aeonbits.owner.loaders.Loader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLoader
implements Loader {
    private static final long serialVersionUID = -894351666332018767L;
    private volatile transient SAXParserFactory factory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SAXParserFactory factory() {
        if (this.factory == null) {
            XMLLoader xMLLoader = this;
            synchronized (xMLLoader) {
                if (this.factory == null) {
                    this.factory = SAXParserFactory.newInstance();
                    this.factory.setValidating(true);
                    this.factory.setNamespaceAware(true);
                }
            }
        }
        return this.factory;
    }

    public boolean accept(URL url) {
        return url.getFile().toLowerCase().endsWith(".xml");
    }

    public void load(Properties result, InputStream input) throws IOException {
        try {
            SAXParser parser = this.factory().newSAXParser();
            XmlToPropsHandler h = new XmlToPropsHandler(result);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", h);
            parser.parse(input, (DefaultHandler)h);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public String defaultSpecFor(String urlPrefix) {
        return urlPrefix + ".xml";
    }

    static class XmlToPropsHandler
    extends DefaultHandler2 {
        private static final String PROPS_DTD_URI = "http://java.sun.com/dtd/properties.dtd";
        private static final String PROPS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for properties --><!ELEMENT properties ( comment?, entry* ) ><!ATTLIST properties version CDATA #FIXED \"1.0\"><!ELEMENT comment (#PCDATA) ><!ELEMENT entry (#PCDATA) ><!ATTLIST entry key CDATA #REQUIRED>";
        private boolean isJavaPropertiesFormat = false;
        private final Properties props;
        private final Stack<String> paths = new Stack();
        private final Stack<StringBuilder> value = new Stack();

        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            InputSource inputSource = null;
            if (systemId.equals(PROPS_DTD_URI)) {
                this.isJavaPropertiesFormat = true;
                inputSource = new InputSource(new StringReader(PROPS_DTD));
                inputSource.setSystemId(PROPS_DTD_URI);
            }
            return inputSource;
        }

        public XmlToPropsHandler(Properties props) {
            this.props = props;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.value.push(new StringBuilder());
            if (this.isJavaPropertiesFormat) {
                if ("entry".equals(qName)) {
                    this.paths.push(attributes.getValue("key"));
                } else {
                    this.paths.push(qName);
                }
            } else {
                String path = this.paths.size() == 0 ? qName : this.paths.peek() + "." + qName;
                this.paths.push(path);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attrName = attributes.getQName(i);
                    String attrValue = attributes.getValue(i);
                    this.props.setProperty(path + "." + attrName, attrValue);
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.value.peek().append(new String(ch, start, length));
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            String key = this.paths.peek();
            String propertyValue = this.value.peek().toString().trim();
            if (!(propertyValue.isEmpty() || this.isJavaPropertiesFormat && "comment".equals(key))) {
                this.props.setProperty(key, propertyValue);
            }
            this.value.pop();
            this.paths.pop();
        }

        public void error(SAXParseException e) throws SAXException {
            if (this.isJavaPropertiesFormat) {
                throw e;
            }
        }
    }
}

