/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aeonbits.owner.Util;
import org.aeonbits.owner.loaders.Loader;
import org.aeonbits.owner.loaders.PropertiesLoader;
import org.aeonbits.owner.loaders.XMLLoader;

class LoadersManager
implements Serializable {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<Loader> loaders = new LinkedList<Loader>();

    LoadersManager() {
        this.registerLoader(new PropertiesLoader());
        this.registerLoader(new XMLLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(Properties result, URL url) throws IOException {
        InputStream stream = url.openStream();
        try {
            Loader loader = this.findLoader(url);
            loader.load(result, stream);
        }
        finally {
            stream.close();
        }
    }

    Loader findLoader(URL url) {
        this.lock.readLock().lock();
        try {
            for (Loader loader : this.loaders) {
                if (!loader.accept(url)) continue;
                Loader loader2 = loader;
                return loader2;
            }
            throw Util.unsupported("Can't resolve a Loader for the URL %s.", url.toString());
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    final void registerLoader(Loader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("loader can't be null");
        }
        this.lock.writeLock().lock();
        try {
            this.loaders.add(0, loader);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void clear() {
        this.lock.writeLock().lock();
        try {
            this.loaders.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] defaultSpecs(String prefix) {
        this.lock.readLock().lock();
        try {
            ArrayList<String> defaultSpecs = new ArrayList<String>(this.loaders.size());
            for (Loader loader : this.loaders) {
                String spec = loader.defaultSpecFor(prefix);
                if (spec == null) continue;
                defaultSpecs.add(spec);
            }
            String[] stringArray = defaultSpecs.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

