/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.net.MalformedURLException;
import java.net.URL;
import org.aeonbits.owner.VariablesExpander;

class ConfigURLFactory {
    private static final String CLASSPATH_PROTOCOL = "classpath:";
    private final transient ClassLoader classLoader;
    private final VariablesExpander expander;

    ConfigURLFactory(ClassLoader classLoader, VariablesExpander expander) {
        this.classLoader = classLoader;
        this.expander = expander;
    }

    URL newURL(String spec) throws MalformedURLException {
        URL url;
        String expanded = this.expand(spec);
        if (expanded.startsWith(CLASSPATH_PROTOCOL)) {
            String path = expanded.substring(CLASSPATH_PROTOCOL.length());
            url = this.classLoader.getResource(path);
            if (url == null) {
                return null;
            }
        } else {
            url = new URL(expanded);
        }
        return new URL(url.getProtocol(), url.getHost(), url.getPort(), this.expand(url.getPath()));
    }

    private String expand(String path) {
        return this.expander.expand(path);
    }

    String toClasspathURLSpec(String name) {
        return CLASSPATH_PROTOCOL + name.replace('.', '/');
    }
}

