/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.DefaultFactory;
import org.aeonbits.owner.Factory;
import org.aeonbits.owner.loaders.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigFactory {
    static final Factory INSTANCE = ConfigFactory.newInstance();

    private ConfigFactory() {
    }

    public static Factory newInstance() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread result = new Thread(r);
                result.setDaemon(true);
                return result;
            }
        });
        Properties props = new Properties();
        return new DefaultFactory(scheduler, props);
    }

    public static <T extends Config> T create(Class<? extends T> clazz, Map<?, ?> ... imports) {
        return INSTANCE.create(clazz, imports);
    }

    public static String setProperty(String key, String value) {
        return INSTANCE.setProperty(key, value);
    }

    public static Properties getProperties() {
        return INSTANCE.getProperties();
    }

    public static void setProperties(Properties properties) {
        INSTANCE.setProperties(properties);
    }

    public static String getProperty(String key) {
        return INSTANCE.getProperty(key);
    }

    public static String clearProperty(String key) {
        return INSTANCE.clearProperty(key);
    }

    public static void registerLoader(Loader loader) {
        INSTANCE.registerLoader(loader);
    }
}

