/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.aeonbits.owner.Converter;
import org.aeonbits.owner.LoadersManager;
import org.aeonbits.owner.Tokenizer;
import org.aeonbits.owner.Util;

public interface Config
extends Serializable {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface ConverterClass {
        public Class<? extends Converter> value();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    public static @interface TokenizerClass {
        public Class<? extends Tokenizer> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    public static @interface Separator {
        public String value();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisableableFeature {
        VARIABLE_EXPANSION,
        PARAMETER_FORMATTING;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Documented
    public static @interface DisableFeature {
        public DisableableFeature[] value();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HotReloadType {
        SYNC,
        ASYNC;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Documented
    public static @interface HotReload {
        public long value() default 5L;

        public TimeUnit unit() default TimeUnit.SECONDS;

        public HotReloadType type() default HotReloadType.SYNC;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoadType {
        FIRST{

            @Override
            Properties load(List<URL> urls, LoadersManager loaders) {
                Properties result = new Properties();
                for (URL url : urls) {
                    try {
                        loaders.load(result, url);
                        break;
                    }
                    catch (IOException ex) {
                        Util.ignore();
                    }
                }
                return result;
            }
        }
        ,
        MERGE{

            @Override
            Properties load(List<URL> urls, LoadersManager loaders) {
                Properties result = new Properties();
                for (URL url : Util.reverse(urls)) {
                    try {
                        loaders.load(result, url);
                    }
                    catch (IOException ex) {
                        Util.ignore();
                    }
                }
                return result;
            }
        };


        abstract Properties load(List<URL> var1, LoadersManager var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface Key {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface DefaultValue {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Documented
    public static @interface Sources {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Documented
    public static @interface LoadPolicy {
        public LoadType value() default LoadType.FIRST;
    }
}

