/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.converters;

import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.aeonbits.owner.Converter;
import org.aeonbits.owner.converters.ConverterUtil;

public class DurationConverter
implements Converter<Duration> {
    public Duration convert(Method method, String input) {
        if (input.startsWith("P") || input.startsWith("-P") || input.startsWith("+P")) {
            return Duration.parse(input);
        }
        return DurationConverter.parseDuration(input);
    }

    private static Duration parseDuration(String input) {
        ChronoUnit units;
        String originalUnitString;
        String[] parts = ConverterUtil.splitNumericAndChar(input);
        String numberString = parts[0];
        String unitString = originalUnitString = parts[1];
        if (numberString.length() == 0) {
            throw new IllegalArgumentException(String.format("No number in duration value '%s'", input));
        }
        if (unitString.length() > 2 && !unitString.endsWith("s")) {
            unitString = unitString + "s";
        }
        switch (unitString) {
            case "ns": 
            case "nanos": 
            case "nanoseconds": {
                units = ChronoUnit.NANOS;
                break;
            }
            case "us": 
            case "\u00b5s": 
            case "micros": 
            case "microseconds": {
                units = ChronoUnit.MICROS;
                break;
            }
            case "": 
            case "ms": 
            case "millis": 
            case "milliseconds": {
                units = ChronoUnit.MILLIS;
                break;
            }
            case "s": 
            case "seconds": {
                units = ChronoUnit.SECONDS;
                break;
            }
            case "m": 
            case "minutes": {
                units = ChronoUnit.MINUTES;
                break;
            }
            case "h": 
            case "hours": {
                units = ChronoUnit.HOURS;
                break;
            }
            case "d": 
            case "days": {
                units = ChronoUnit.DAYS;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Could not parse time unit '%s' (try ns, us, ms, s, m, h, d)", originalUnitString));
            }
        }
        return Duration.of(Long.parseLong(numberString), units);
    }
}

