/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.validator;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.KeyInfoType;
import org.opensaml.xml.signature.KeyName;
import org.opensaml.xml.signature.KeyValue;
import org.opensaml.xml.signature.MgmtData;
import org.opensaml.xml.signature.PGPData;
import org.opensaml.xml.signature.RetrievalMethod;
import org.opensaml.xml.signature.SPKIData;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfoTypeSchemaValidator
implements Validator<KeyInfoType> {
    private static final Set<QName> VALID_DS_CHILD_NAMES = new HashSet<QName>();

    @Override
    public void validate(KeyInfoType xmlObject) throws ValidationException {
        this.validateChildrenPresence(xmlObject);
        this.validateChildrenNamespaces(xmlObject);
    }

    protected static Set<QName> getValidDSChildNames() {
        return VALID_DS_CHILD_NAMES;
    }

    protected void validateChildrenPresence(KeyInfoType xmlObject) throws ValidationException {
        if (xmlObject.getXMLObjects().isEmpty()) {
            throw new ValidationException("No children were present in the KeyInfoType object");
        }
    }

    protected void validateChildrenNamespaces(KeyInfoType xmlObject) throws ValidationException {
        for (XMLObject child : xmlObject.getXMLObjects()) {
            QName childName = child.getElementQName();
            if (KeyInfoTypeSchemaValidator.getValidDSChildNames().contains(childName) || !"http://www.w3.org/2000/09/xmldsig#".equals(childName.getNamespaceURI())) continue;
            throw new ValidationException("KeyInfoType contains an illegal child extension element: " + childName);
        }
    }

    static {
        VALID_DS_CHILD_NAMES.add(KeyName.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(KeyValue.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(RetrievalMethod.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(X509Data.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(PGPData.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(SPKIData.DEFAULT_ELEMENT_NAME);
        VALID_DS_CHILD_NAMES.add(MgmtData.DEFAULT_ELEMENT_NAME);
    }
}

