/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.namespace.QName;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeMap
implements Map<QName, String> {
    private XMLObject attributeOwner;
    private Map<QName, String> attributes;
    private Set<QName> idAttribNames;

    public AttributeMap(XMLObject newOwner) throws NullPointerException {
        if (newOwner == null) {
            throw new NullPointerException("Attribute owner XMLObject may not be null");
        }
        this.attributeOwner = newOwner;
        this.attributes = new ConcurrentHashMap<QName, String>();
        this.idAttribNames = new CopyOnWriteArraySet<QName>();
    }

    @Override
    public String put(QName attributeName, String value) {
        String oldValue = this.get(attributeName);
        if (value != oldValue) {
            this.releaseDOM();
            this.attributes.put(attributeName, value);
            if (this.isIDAttribute(attributeName) || Configuration.isIDAttribute(attributeName)) {
                this.attributeOwner.getIDIndex().deregisterIDMapping(oldValue);
                this.attributeOwner.getIDIndex().registerIDMapping(value, this.attributeOwner);
            }
        }
        return oldValue;
    }

    @Override
    public void clear() {
        for (QName attributeName : this.attributes.keySet()) {
            this.remove(attributeName);
        }
    }

    @Override
    public Set<QName> keySet() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.attributes.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public String remove(Object key) {
        String removedValue = this.attributes.remove(key);
        if (removedValue != null) {
            this.releaseDOM();
            QName attributeName = (QName)key;
            if (this.isIDAttribute(attributeName) || Configuration.isIDAttribute(attributeName)) {
                this.attributeOwner.getIDIndex().deregisterIDMapping(removedValue);
            }
        }
        return removedValue;
    }

    @Override
    public void putAll(Map<? extends QName, ? extends String> t) {
        if (t != null && t.size() > 0) {
            for (Map.Entry<? extends QName, ? extends String> entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    @Override
    public Set<Map.Entry<QName, String>> entrySet() {
        return Collections.unmodifiableSet(this.attributes.entrySet());
    }

    public void registerID(QName attributeName) {
        if (!this.idAttribNames.contains(attributeName)) {
            this.idAttribNames.add(attributeName);
        }
        if (this.containsKey(attributeName)) {
            this.attributeOwner.getIDIndex().registerIDMapping(this.get(attributeName), this.attributeOwner);
        }
    }

    public void deregisterID(QName attributeName) {
        if (this.idAttribNames.contains(attributeName)) {
            this.idAttribNames.remove(attributeName);
        }
        if (this.containsKey(attributeName)) {
            this.attributeOwner.getIDIndex().deregisterIDMapping(this.get(attributeName));
        }
    }

    public boolean isIDAttribute(QName attributeName) {
        return this.idAttribNames.contains(attributeName);
    }

    private void releaseDOM() {
        this.attributeOwner.releaseDOM();
        this.attributeOwner.releaseParentDOM(true);
    }
}

