/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.util.List;
import javax.xml.namespace.QName;
import javolution.util.FastList;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.BaseMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingMetadataProvider
extends BaseMetadataProvider {
    private FastList<MetadataProvider> providers = new FastList();

    public List<MetadataProvider> getProviders() {
        return this.providers.unmodifiable();
    }

    public void setProviders(List<MetadataProvider> newProviders) throws MetadataProviderException {
        this.providers.clear();
        for (MetadataProvider provider : newProviders) {
            this.addMetadataProvider(provider);
        }
    }

    public void addMetadataProvider(MetadataProvider newProvider) throws MetadataProviderException {
        if (newProvider != null) {
            newProvider.setRequireValidMetadata(this.requireValidMetadata());
            newProvider.setMetadataFilter(this.getMetadataFilter());
            this.providers.add((Object)newProvider);
        }
    }

    public void removeMetadataProvider(MetadataProvider provider) {
        this.providers.remove((Object)provider);
    }

    @Override
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        super.setRequireValidMetadata(requireValidMetadata);
        FastList.Node head = this.providers.head();
        for (FastList.Node current = head.getNext(); current != this.providers.tail(); current = current.getNext()) {
            MetadataProvider provider = (MetadataProvider)current.getValue();
            provider.setRequireValidMetadata(requireValidMetadata);
        }
    }

    @Override
    public void setMetadataFilter(MetadataFilter newFilter) throws MetadataProviderException {
        super.setMetadataFilter(newFilter);
        FastList.Node head = this.providers.head();
        for (FastList.Node current = head.getNext(); current != this.providers.tail(); current = current.getNext()) {
            MetadataProvider provider = (MetadataProvider)current.getValue();
            provider.setMetadataFilter(newFilter);
        }
    }

    @Override
    public XMLObject getMetadata() throws MetadataProviderException {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SAMLObjectBuilder builder = (SAMLObjectBuilder)builderFactory.getBuilder(EntitiesDescriptor.DEFAULT_ELEMENT_NAME);
        EntitiesDescriptor metadataRoot = (EntitiesDescriptor)builder.buildObject();
        FastList.Node head = this.providers.head();
        for (FastList.Node current = head.getNext(); current != this.providers.tail(); current = current.getNext()) {
            MetadataProvider provider = (MetadataProvider)current.getValue();
            XMLObject providerMetadata = provider.getMetadata();
            if (providerMetadata instanceof EntitiesDescriptor) {
                metadataRoot.getEntitiesDescriptors().add((EntitiesDescriptor)providerMetadata);
                continue;
            }
            if (!(providerMetadata instanceof EntityDescriptor)) continue;
            metadataRoot.getEntityDescriptors().add((EntityDescriptor)providerMetadata);
        }
        return metadataRoot;
    }

    @Override
    public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
        FastList.Node head = this.providers.head();
        for (FastList.Node current = head.getNext(); current != this.providers.tail(); current = current.getNext()) {
            MetadataProvider provider = (MetadataProvider)current.getValue();
            EntitiesDescriptor descriptor = provider.getEntitiesDescriptor(name);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        FastList.Node head = this.providers.head();
        for (FastList.Node current = head.getNext(); current != this.providers.tail(); current = current.getNext()) {
            MetadataProvider provider = (MetadataProvider)current.getValue();
            EntityDescriptor descriptor = provider.getEntityDescriptor(entityID);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        FastList.Node head = this.providers.head();
        for (FastList.Node current = head.getNext(); current != this.providers.tail(); current = current.getNext()) {
            MetadataProvider provider = (MetadataProvider)current.getValue();
            List<RoleDescriptor> roles = provider.getRole(entityID, roleName);
            if (roles == null || roles.size() <= 0) continue;
            return roles;
        }
        return null;
    }

    @Override
    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        FastList.Node head = this.providers.head();
        FastList.Node current = head.getNext();
        if (current != this.providers.tail()) {
            MetadataProvider provider = (MetadataProvider)current.getValue();
            return provider.getRole(entityID, roleName, supportedProtocol);
        }
        return null;
    }
}

