/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.impl;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.opensaml.common.impl.AbstractSAMLObjectMarshaller;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class RoleDescriptorMarshaller
extends AbstractSAMLObjectMarshaller {
    private static Logger log = Logger.getLogger(RoleDescriptorMarshaller.class);

    protected RoleDescriptorMarshaller(String targetNamespaceURI, String targetLocalName) {
        super(targetNamespaceURI, targetLocalName);
    }

    protected void marshallAttributes(XMLObject samlElement, Element domElement) throws MarshallingException {
        List<String> supportedProtocols;
        RoleDescriptor roleDescriptor = (RoleDescriptor)samlElement;
        if (roleDescriptor.getID() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Writing ID attribute to RoleDescriptor DOM element");
            }
            domElement.setAttributeNS(null, "ID", roleDescriptor.getID());
            domElement.setIdAttributeNS(null, "ID", true);
        }
        if (roleDescriptor.getValidUntil() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Writting validUntil attribute to RoleDescriptor DOM element");
            }
            String validUntilStr = ISODateTimeFormat.dateTime().print((ReadableInstant)roleDescriptor.getValidUntil());
            domElement.setAttributeNS(null, "validUntil", validUntilStr);
        }
        if (roleDescriptor.getCacheDuration() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Writting cacheDuration attribute to EntitiesDescriptor DOM element");
            }
            String cacheDuration = XMLHelper.longToDuration((long)roleDescriptor.getCacheDuration());
            domElement.setAttributeNS(null, "cacheDuration", cacheDuration);
        }
        if ((supportedProtocols = roleDescriptor.getSupportedProtocols()) != null && supportedProtocols.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Writting protocolSupportEnumberation attribute to RoleDescriptor DOM element");
            }
            StringBuilder builder = new StringBuilder();
            for (String protocol : supportedProtocols) {
                builder.append(protocol);
                builder.append(" ");
            }
            domElement.setAttributeNS(null, "protocolSupportEnumeration", builder.toString().trim());
        }
        if (roleDescriptor.getErrorURL() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Writting errorURL attribute to RoleDescriptor DOM element");
            }
            domElement.setAttributeNS(null, "errorURL", roleDescriptor.getErrorURL());
        }
        for (Map.Entry entry : roleDescriptor.getUnknownAttributes().entrySet()) {
            Attr attribute = XMLHelper.constructAttribute((Document)domElement.getOwnerDocument(), (QName)((QName)entry.getKey()));
            attribute.setValue((String)entry.getValue());
            domElement.setAttributeNodeNS(attribute);
            if (!Configuration.isIDAttribute((QName)((QName)entry.getKey())) && !roleDescriptor.getUnknownAttributes().isIDAttribute((QName)entry.getKey())) continue;
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
    }
}

