/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import java.util.List;
import javolution.util.FastMap;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeQuery;
import org.opensaml.saml2.core.validator.SubjectQuerySchemaValidator;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeQuerySchemaValidator
extends SubjectQuerySchemaValidator<AttributeQuery> {
    @Override
    public void validate(AttributeQuery query) throws ValidationException {
        super.validate(query);
        this.validateUniqueAttributeIdentifiers(query);
    }

    protected void validateUniqueAttributeIdentifiers(AttributeQuery query) throws ValidationException {
        List<Attribute> attributes = query.getAttributes();
        FastMap encounteredNames = new FastMap();
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            String attributeNameFormat = attribute.getNameFormat();
            if (DatatypeHelper.safeEquals((Object)attributeNameFormat, (Object)encounteredNames.get((Object)attributeName))) {
                throw new ValidationException("Attribute query contains more than one attribute with the same Name and NameFormat");
            }
            encounteredNames.put((Object)attributeName, (Object)attributeNameFormat);
        }
    }
}

