/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.impl;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.common.impl.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.SubjectLocality;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class AuthnStatementUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    public AuthnStatementUnmarshaller() {
        super("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnStatement");
    }

    protected AuthnStatementUnmarshaller(String namespaceURI, String elementLocalName) {
        super(namespaceURI, elementLocalName);
    }

    protected void processChildElement(XMLObject parentObject, XMLObject childObject) throws UnmarshallingException {
        AuthnStatement authnStatement = (AuthnStatement)parentObject;
        if (childObject instanceof SubjectLocality) {
            authnStatement.setSubjectLocality((SubjectLocality)childObject);
        } else if (childObject instanceof AuthnContext) {
            authnStatement.setAuthnContext((AuthnContext)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        AuthnStatement authnStatement = (AuthnStatement)samlObject;
        if (attribute.getLocalName().equals("AuthnInstant")) {
            authnStatement.setAuthnInstant(new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC()));
        } else if (attribute.getLocalName().equals("SessionIndex")) {
            authnStatement.setSessionIndex(attribute.getValue());
        } else if (attribute.getLocalName().equals("SessionNotOnOrAfter")) {
            authnStatement.setSessionNotOnOrAfter(new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC()));
        } else {
            super.processAttribute(samlObject, attribute);
        }
    }
}

