/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.encoding;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.BindingException;
import org.opensaml.saml2.binding.encoding.AbstractSAML2HTTPMessageEncoder;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.Response;
import org.opensaml.util.URLBuilder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.Pair;

public class HTTPRedirectDeflateEncoder
extends AbstractSAML2HTTPMessageEncoder {
    public static final String BINDING_URI = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    public static final String DSA_SHA1_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String RSA_SHA1_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private static Logger log = Logger.getLogger(HTTPRedirectDeflateEncoder.class);

    public String getBindingURI() {
        return BINDING_URI;
    }

    public void encode() throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Beginning SAML 2 HTTP Redirect encoding");
        }
        this.removeSignature();
        byte[] encodedMessage = this.defalteAndBase64Encode(this.getSamlMessage());
        String redirectURL = this.buildRedirectURL(new String(encodedMessage));
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Redirect encoding complete, redirecting client to " + redirectURL));
            }
            this.initializeResponse();
            ((HttpServletResponse)this.getResponse()).setCharacterEncoding("UTF-8");
            ((HttpServletResponse)this.getResponse()).sendRedirect(redirectURL);
        }
        catch (IOException e) {
            log.error((Object)("Unable to redirect client to " + redirectURL), (Throwable)e);
            throw new BindingException("Unable to redirect client", e);
        }
    }

    protected void removeSignature() {
        SignableSAMLObject message = (SignableSAMLObject)this.getSamlMessage();
        if (message.isSigned()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Removing SAML protocol message signature");
            }
            message.setSignature(null);
        }
    }

    protected byte[] defalteAndBase64Encode(SAMLObject message) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deflating and Base64 encoding SAML message");
        }
        try {
            String messageStr = this.marshallMessage((XMLObject)message);
            ByteArrayOutputStream messageOut = new ByteArrayOutputStream();
            Base64.OutputStream b64Out = new Base64.OutputStream((OutputStream)messageOut);
            Deflater deflater = new Deflater(8, true);
            DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)b64Out, deflater);
            deflaterStream.write(messageStr.getBytes());
            deflaterStream.close();
            return messageOut.toByteArray();
        }
        catch (IOException e) {
            throw new BindingException("Unable to DEFLATE and Base64 encode SAML message", e);
        }
    }

    protected String buildRedirectURL(String message) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Building URL to redirect client to");
        }
        URLBuilder urlBuilder = new URLBuilder(this.getEndpointURL());
        List queryParams = urlBuilder.getQueryParams();
        queryParams.clear();
        if (this.getSamlMessage() instanceof RequestAbstractType) {
            queryParams.add(new Pair((Object)"SAMLRequest", (Object)message));
        } else if (this.getSamlMessage() instanceof Response) {
            queryParams.add(new Pair((Object)"SAMLResponse", (Object)message));
        } else {
            throw new BindingException("SAML message is neither a SAML RequestAbstractType or Response");
        }
        if (this.checkRelayState()) {
            queryParams.add(new Pair((Object)"RelayState", (Object)this.getEncodeRelayState()));
        }
        if (this.getSigningCredential() != null) {
            Pair sigAlg = new Pair((Object)"SigAlg", (Object)this.getSignatureAlgorithm());
            queryParams.add(sigAlg);
            String sigMaterial = urlBuilder.buildQueryString();
            queryParams.add(new Pair((Object)"Signature", (Object)this.generateSignature((String)sigAlg.getSecond(), sigMaterial)));
        }
        return urlBuilder.buildURL();
    }

    protected String getSignatureAlgorithm() throws BindingException {
        if (this.getSigningCredential().getPrivateKey() instanceof RSAPrivateKey) {
            return "SHA1withRSA";
        }
        if (this.getSigningCredential().getPrivateKey() instanceof DSAPrivateKey) {
            return "SHA1withDSA";
        }
        throw new BindingException("Encoder only supports signing with RSA or DSA keys.");
    }

    protected String generateSignature(String algorithm, String queryString) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating digital signature of query string using algorithm " + this.getSignatureAlgorithm()));
        }
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(this.getSigningCredential().getPrivateKey());
            signature.update(queryString.getBytes());
            byte[] rawSignature = signature.sign();
            return Base64.encodeBytes((byte[])rawSignature);
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"Error during URL signing process", (Throwable)e);
            throw new BindingException("Unable to sign URL query string", e);
        }
    }
}

