/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.encoding;

import java.io.IOException;
import java.io.InputStream;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.opensaml.common.binding.artifact.SAMLArtifactFactory;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.common.binding.encoding.MessageEncoder;
import org.opensaml.common.binding.encoding.MessageEncoderBuilder;
import org.opensaml.saml2.binding.encoding.HTTPArtifactEncoder;
import org.opensaml.xml.util.DatatypeHelper;

public class HTTPArtifactEncoderBuilder
implements MessageEncoderBuilder {
    private SAMLArtifactMap artifactMap;
    private SAMLArtifactFactory artifactFactory;
    private HTTPArtifactEncoder.ENCODING_METHOD encodingMethod;
    private VelocityEngine velocityEngine;
    private String velocityTempalteId;

    public HTTPArtifactEncoderBuilder(SAMLArtifactFactory factory, SAMLArtifactMap map) {
        this.encodingMethod = HTTPArtifactEncoder.ENCODING_METHOD.URL;
        this.artifactFactory = factory;
        this.artifactMap = map;
    }

    public HTTPArtifactEncoderBuilder(SAMLArtifactFactory factory, SAMLArtifactMap map, VelocityEngine engine, String templatePath) throws IOException {
        this.encodingMethod = HTTPArtifactEncoder.ENCODING_METHOD.FORM;
        this.artifactFactory = factory;
        this.artifactMap = map;
        this.velocityEngine = engine;
        this.velocityTempalteId = templatePath;
        this.registerTemplate(templatePath);
    }

    public MessageEncoder buildEncoder() {
        HTTPArtifactEncoder encoder = new HTTPArtifactEncoder();
        encoder.setArtifactFactory(this.artifactFactory);
        encoder.setArtifactMap(this.artifactMap);
        encoder.setEncodingMethod(this.encodingMethod);
        encoder.setVelocityEngine(this.velocityEngine);
        encoder.setVelocityTemplateId(this.velocityTempalteId);
        return encoder;
    }

    protected void registerTemplate(String templatePath) throws IOException {
        StringResourceRepository repository = StringResourceLoader.getRepository();
        String template = DatatypeHelper.inputstreamToString((InputStream)this.getClass().getResourceAsStream(templatePath), null);
        repository.putStringResource(templatePath, template);
    }
}

