/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.encoding;

import org.opensaml.Configuration;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.encoding.impl.AbstractHTTPMessageEncoder;
import org.opensaml.common.impl.SAMLObjectContentReference;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.DatatypeHelper;

public abstract class AbstractSAML2HTTPMessageEncoder
extends AbstractHTTPMessageEncoder {
    protected String getEndpointURL() throws BindingException {
        Endpoint endpoint = this.getRelyingPartyEndpoint();
        if (endpoint == null) {
            throw new BindingException("Endpoint for relying party was null.");
        }
        if (this.getSamlMessage() instanceof Response && !DatatypeHelper.isEmpty((String)endpoint.getResponseLocation())) {
            return endpoint.getResponseLocation();
        }
        if (DatatypeHelper.isEmpty((String)endpoint.getLocation())) {
            throw new BindingException("Relying party endpoint location was null or empty.");
        }
        return endpoint.getLocation();
    }

    protected boolean checkRelayState() throws BindingException {
        if (!DatatypeHelper.isEmpty((String)this.getRelayState())) {
            if (this.getRelayState().getBytes().length > 80) {
                throw new BindingException("Relay state exceeds 80 bytes.");
            }
            return true;
        }
        return false;
    }

    protected void signMessage() {
        if (this.getSamlMessage() instanceof SignableSAMLObject && this.getSigningCredential() != null) {
            SignableSAMLObject signableMessage = (SignableSAMLObject)this.getSamlMessage();
            SAMLObjectContentReference contentRef = new SAMLObjectContentReference(signableMessage);
            XMLObjectBuilder signatureBuilder = Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
            Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.getContentReferences().add(contentRef);
            signableMessage.setSignature(signature);
            Signer.signObject((Signature)signature);
        }
    }
}

