/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.validator;

import javax.xml.namespace.QName;
import org.opensaml.saml1.core.StatusCode;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCodeSchemaValidator
implements Validator<StatusCode> {
    private static final String[] allowedCodes = new String[]{"Success", "VersionMismatch", "Requester", "Responder", "RequestVersionTooHigh", "RequestVersionTooLow", "RequestVersionDeprecated", "TooManyResponses", "RequestDenied", "ResourceNotRecognized"};

    public void validate(StatusCode statusCode) throws ValidationException {
        this.validateValue(statusCode);
        this.validateValueQNameNamespace(statusCode);
        this.validateValueContent(statusCode);
    }

    protected void validateValue(StatusCode statusCode) throws ValidationException {
        String value = statusCode.getValue();
        if (DatatypeHelper.isEmpty((String)value)) {
            throw new ValidationException("No Value attribute present");
        }
    }

    protected void validateValueQNameNamespace(StatusCode statusCode) throws ValidationException {
        String value = statusCode.getValue();
        QName qname = QName.valueOf(value);
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(qname.getNamespaceURI())) {
            throw new ValidationException("value Qname cannot be in the SAML1 Assertion namespace");
        }
    }

    protected void validateValueContent(StatusCode statusCode) throws ValidationException {
        String value = statusCode.getValue();
        QName qname = QName.valueOf(value);
        if ("urn:oasis:names:tc:SAML:1.0:protocol".equals(qname.getNamespaceURI())) {
            String localName = qname.getLocalPart();
            boolean allowedName = false;
            for (int i = 0; i < allowedCodes.length; ++i) {
                if (!allowedCodes[i].equals(localName)) continue;
                allowedName = true;
                break;
            }
            if (!allowedName) {
                throw new ValidationException(localName + " is not a valid local name");
            }
        }
    }
}

