/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.encoding;

import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.Configuration;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.encoding.impl.AbstractHTTPMessageEncoder;
import org.opensaml.common.impl.SAMLObjectContentReference;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;

public class HTTPPostEncoder
extends AbstractHTTPMessageEncoder {
    public static final String BINDING_URI = "urn:oasis:names:tc:SAML:1.0:profiles:browser-post";
    private final Logger log = Logger.getLogger(HTTPPostEncoder.class);
    private VelocityEngine velocityEngine;
    private String velocityTemplateId;

    public String getBindingURI() {
        return BINDING_URI;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine engine) {
        this.velocityEngine = engine;
    }

    public String getVelocityTemplateId() {
        return this.velocityTemplateId;
    }

    public void setVelocityTemplateId(String id) {
        this.velocityTemplateId = id;
    }

    public void encode() throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Beginning SAML 2 HTTP POST encoding");
        }
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        this.signMessage();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Marshalling SAML message");
        }
        String messageXML = this.marshallMessage((XMLObject)this.getSamlMessage());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Base64 encoding message");
        }
        String encodedMessage = new String(Base64.encodeBytes((byte[])messageXML.getBytes(), (int)8));
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Adding cache headers to response");
            }
            response.setContentType("application/xhtml+xml");
            response.setCharacterEncoding("UTF-8");
            this.initializeResponse();
            this.postEncode(response.getWriter(), encodedMessage);
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to access HttpServletResponse output writer", (Throwable)e);
            throw new BindingException("Unable to access HttpServletResponse output writer", e);
        }
    }

    protected void postEncode(Writer responseWriter, String message) throws BindingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Performing SAML 1 HTTP POST encoding");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Invoking velocity template");
        }
        try {
            VelocityContext context = new VelocityContext();
            context.put("action", (Object)this.getEndpointURL());
            context.put("SAMLResponse", (Object)message);
            context.put("Target", (Object)URLEncoder.encode(this.getRelayState(), "UTF-8"));
            this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, responseWriter);
        }
        catch (Exception e) {
            this.log.error((Object)"Error invoking velocity template", (Throwable)e);
            throw new BindingException("Error creating output document", e);
        }
    }

    protected String getEndpointURL() throws BindingException {
        Endpoint endpoint = this.getRelyingPartyEndpoint();
        if (endpoint == null) {
            throw new BindingException("Relying party endpoint provided we null.");
        }
        if (this.getSamlMessage() instanceof Response && !DatatypeHelper.isEmpty((String)endpoint.getResponseLocation())) {
            return endpoint.getResponseLocation();
        }
        if (DatatypeHelper.isEmpty((String)endpoint.getLocation())) {
            throw new BindingException("Relying party endpoint location was null or empty.");
        }
        return endpoint.getLocation();
    }

    protected void signMessage() {
        if (this.getSamlMessage() instanceof SignableSAMLObject && this.getSigningCredential() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Signing SAML message.");
            }
            SignableSAMLObject signableMessage = (SignableSAMLObject)this.getSamlMessage();
            SAMLObjectContentReference contentRef = new SAMLObjectContentReference(signableMessage);
            XMLObjectBuilder signatureBuilder = Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
            Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.getContentReferences().add(contentRef);
            signableMessage.setSignature(signature);
            Signer.signObject((Signature)signature);
        }
    }
}

