/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.opensaml.common.binding.security.SAMLSecurityPolicyContext;
import org.opensaml.util.storage.ReplayCache;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.SecurityPolicyRuleFactory;
import org.opensaml.xml.XMLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayRuleFactory
implements SecurityPolicyRuleFactory<ServletRequest> {
    private int clockSkew;
    private int expires;
    private ReplayCache replayCache;

    public int getClockSkew() {
        return this.clockSkew;
    }

    public void setClockSkew(int newClockSkew) {
        this.clockSkew = newClockSkew;
    }

    public int getExpires() {
        return this.expires;
    }

    public void setExpires(int newExpires) {
        this.expires = newExpires;
    }

    public ReplayCache getReplayCache() {
        return this.replayCache;
    }

    public void setReplayCache(ReplayCache newReplayCache) {
        this.replayCache = newReplayCache;
    }

    public SecurityPolicyRule<ServletRequest> createRuleInstance() {
        return new ReplayRule(this.clockSkew, this.expires, this.replayCache);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReplayRule
    implements SecurityPolicyRule<ServletRequest> {
        private int clockSkew;
        private int expires;
        private ReplayCache replayCache;

        public ReplayRule(int newClockSkew, int newExpires, ReplayCache newReplayCache) {
            this.clockSkew = newClockSkew;
            this.expires = newExpires;
            this.replayCache = newReplayCache;
        }

        public void evaluate(ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
            Logger log = Logger.getLogger(ReplayRule.class);
            if (this.replayCache == null) {
                log.warn((Object)"No replay cache configured, skipping message replay check");
                return;
            }
            SAMLSecurityPolicyContext samlContext = (SAMLSecurityPolicyContext)context;
            if (samlContext == null) {
                log.error((Object)"Supplied context was not an instance of SAMLSecurityPolicyContext");
                throw new IllegalArgumentException("Supplied context was not an instance of SAMLSecurityPolicyContext");
            }
            if (samlContext.getMessageID() == null) {
                log.debug((Object)"Message contained no ID, replay check not possible");
                return;
            }
            DateTime effectiveIssueInstant = samlContext.getIssueInstant();
            if (effectiveIssueInstant == null) {
                log.debug((Object)"Message did not contain issue instant, using current time for replay checking");
                effectiveIssueInstant = new DateTime();
            }
            DateTime expiration = effectiveIssueInstant.plusSeconds(this.clockSkew + this.expires);
            if (this.replayCache.isReplay(samlContext.getMessageID(), expiration)) {
                log.error((Object)("Replay detected of message '" + samlContext.getMessageID() + "'"));
                throw new SecurityPolicyException("Rejecting replayed message ID '" + samlContext.getMessageID() + "'");
            }
        }
    }
}

