/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.encoding.impl;

import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletResponse;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.encoding.MessageEncoder;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageEncoder<ResponseType extends ServletResponse>
implements MessageEncoder<ResponseType> {
    private MetadataProvider metadataProvider;
    private String issuer;
    private EntityDescriptor relyingParty;
    private RoleDescriptor relyingPartyRole;
    private Endpoint relyingPartyEndpoint;
    private SAMLObject samlMessage;
    private Credential signingCredential;
    private ResponseType response;

    @Override
    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public void setMetadataProvider(MetadataProvider provider) {
        this.metadataProvider = provider;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public void setIssuer(String id) {
        this.issuer = id;
    }

    @Override
    public EntityDescriptor getRelyingParty() {
        return this.relyingParty;
    }

    @Override
    public void setRelyingParty(EntityDescriptor entity) {
        this.relyingParty = entity;
    }

    @Override
    public Endpoint getRelyingPartyEndpoint() {
        return this.relyingPartyEndpoint;
    }

    @Override
    public void setRelyingPartyEndpoint(Endpoint endpoint) {
        this.relyingPartyEndpoint = endpoint;
    }

    @Override
    public RoleDescriptor getRelyingPartyRole() {
        return this.relyingPartyRole;
    }

    @Override
    public void setRelyingPartyRole(RoleDescriptor role) {
        this.relyingPartyRole = role;
    }

    @Override
    public SAMLObject getSamlMessage() {
        return this.samlMessage;
    }

    @Override
    public void setSamlMessage(SAMLObject message) {
        this.samlMessage = message;
    }

    @Override
    public Credential getSigningCredential() {
        return this.signingCredential;
    }

    @Override
    public void setSigningCredential(Credential credential) {
        this.signingCredential = credential;
    }

    @Override
    public ResponseType getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(ResponseType rpResponse) {
        this.response = rpResponse;
    }

    protected String marshallMessage(XMLObject message) throws BindingException {
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(message);
            Element messageDOM = marshaller.marshall(message);
            StringWriter writer = new StringWriter();
            XMLHelper.writeNode((Node)messageDOM, (Writer)writer);
            return writer.toString();
        }
        catch (MarshallingException e) {
            throw new BindingException("Unable to marshall XML message", (Exception)((Object)e));
        }
    }
}

