/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.decoding.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.decoding.SOAPHTTPDecoder;
import org.opensaml.common.binding.decoding.impl.AbstractHTTPMessageDecoder;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.xml.XMLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSOAPHTTPDecoder
extends AbstractHTTPMessageDecoder
implements SOAPHTTPDecoder {
    private static Logger log = Logger.getLogger(AbstractSOAPHTTPDecoder.class);
    private Envelope soapMessage;
    private String soapVersion = "1.1";

    @Override
    public Envelope getSOAPMessage() {
        return this.soapMessage;
    }

    @Override
    public List<XMLObject> getSOAPHeaders() {
        if (this.soapMessage != null && this.soapMessage.getHeader() != null) {
            return this.soapMessage.getHeader().getUnknownXMLObjects();
        }
        return null;
    }

    @Override
    public String getSOAPVersion() {
        return this.soapVersion;
    }

    @Override
    public void decode() throws BindingException, SecurityPolicyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Beginning SAML 2 HTTP SOAP 1.1 decoding");
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        this.setHttpMethod("POST");
        try {
            this.soapMessage = (Envelope)this.unmarshallMessage((InputStream)request.getInputStream());
            List soapBodyChildren = this.soapMessage.getBody().getUnknownXMLObjects();
            if (soapBodyChildren.size() < 1 || soapBodyChildren.size() > 1) {
                log.error((Object)("Unexpected number of children in the SOAP body, " + soapBodyChildren.size() + ".  Unable to extract SAML message"));
                throw new BindingException("Unexpected number of children in the SOAP body, unable to extract SAML message");
            }
            this.setSAMLMessage((SAMLObject)soapBodyChildren.get(0));
            this.evaluateSecurityPolicy((XMLObject)this.soapMessage);
        }
        catch (IOException e) {
            log.error((Object)"Unable to read SOAP message from request", (Throwable)e);
            throw new BindingException("Unable to read SOAP message from request", e);
        }
    }
}

