/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.decoding.impl;

import org.opensaml.common.binding.decoding.MessageDecoderBuilder;
import org.opensaml.common.binding.decoding.impl.AbstractMessageDecoder;
import org.opensaml.common.binding.security.SAMLSecurityPolicy;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.ws.security.SecurityPolicyFactory;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.trust.TrustEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageDecoderBuilder<MessageDecoderType extends AbstractMessageDecoder>
implements MessageDecoderBuilder<MessageDecoderType> {
    private SecurityPolicyFactory policyFactory;
    private TrustEngine trustEngine;
    private ParserPool parser;
    private MetadataProvider metadataProvider;

    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(MetadataProvider provider) {
        this.metadataProvider = provider;
    }

    public ParserPool getParser() {
        return this.parser;
    }

    public void setParser(ParserPool pool) {
        this.parser = pool;
    }

    public SecurityPolicyFactory getPolicyFactory() {
        return this.policyFactory;
    }

    public void setPolicyFactory(SecurityPolicyFactory factory) {
        this.policyFactory = factory;
    }

    public TrustEngine getTrustEngine() {
        return this.trustEngine;
    }

    public void setTrustEngine(TrustEngine engine) {
        this.trustEngine = engine;
    }

    @Override
    public MessageDecoderType buildDecoder() {
        MessageDecoderType decoder = this.doBuildEncoder();
        ((AbstractMessageDecoder)decoder).setMetadataProvider(this.metadataProvider);
        ((AbstractMessageDecoder)decoder).setParserPool(this.parser);
        ((AbstractMessageDecoder)decoder).setTrustEngine(this.trustEngine);
        if (this.policyFactory != null) {
            ((AbstractMessageDecoder)decoder).setSecurityPolicy((SAMLSecurityPolicy)this.policyFactory.createPolicyInstance());
        }
        return decoder;
    }

    protected abstract MessageDecoderType doBuildEncoder();
}

