/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common;

public class SAMLVersion {
    public static final SAMLVersion VERSION_10 = new SAMLVersion(1, 0);
    public static final SAMLVersion VERSION_11 = new SAMLVersion(1, 1);
    public static final SAMLVersion VERSION_20 = new SAMLVersion(2, 0);
    private int majorVersion;
    private int minorVersion;
    private String versionString;

    private SAMLVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.versionString = majorVersion + "." + minorVersion;
    }

    public static final SAMLVersion valueOf(int majorVersion, int minorVersion) {
        if (majorVersion == 1) {
            if (minorVersion == 0) {
                return VERSION_10;
            }
            if (minorVersion == 1) {
                return VERSION_11;
            }
        } else if (majorVersion == 2 && minorVersion == 0) {
            return VERSION_20;
        }
        return null;
    }

    public static final SAMLVersion valueOf(String version) {
        String[] components = version.split("\\.");
        return SAMLVersion.valueOf(Integer.valueOf(components[0]), Integer.valueOf(components[1]));
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String toString() {
        return this.versionString;
    }
}

