/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.credentials;

import java.io.File;
import java.util.Map;
import nu.studer.gradle.credentials.AddCredentialsTask;
import nu.studer.gradle.credentials.RemoveCredentialsTask;
import nu.studer.gradle.credentials.domain.CredentialsContainer;
import nu.studer.gradle.credentials.domain.CredentialsEncryptor;
import nu.studer.gradle.credentials.domain.CredentialsPersistenceManager;
import nu.studer.gradle.util.MD5;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsPlugin
implements Plugin<Project> {
    public static final String DEFAULT_PASSPHRASE_CREDENTIALS_FILE = "gradle.encrypted.properties";
    public static final String DEFAULT_PASSPHRASE = ">>Default passphrase to encrypt passwords!<<";
    public static final String CREDENTIALS_CONTAINER_PROPERTY = "credentials";
    public static final String CREDENTIALS_PASSPHRASE_PROPERTY = "credentialsPassphrase";
    public static final String CREDENTIALS_KEY_PROPERTY = "credentialsKey";
    public static final String CREDENTIALS_VALUE_PROPERTY = "credentialsValue";
    public static final String ADD_CREDENTIALS_TASK_NAME = "addCredentials";
    public static final String REMOVE_CREDENTIALS_TASK_NAME = "removeCredentials";
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialsPlugin.class);

    public void apply(Project project) {
        String passphrase = this.getProjectProperty(CREDENTIALS_PASSPHRASE_PROPERTY, DEFAULT_PASSPHRASE, project);
        String credentialsFileName = this.deriveFileNameFromPassphrase(passphrase);
        CredentialsEncryptor credentialsEncryptor = CredentialsEncryptor.withPassphrase(DEFAULT_PASSPHRASE.toCharArray());
        File gradleUserHomeDir = project.getGradle().getGradleUserHomeDir();
        File credentialsFile = new File(gradleUserHomeDir, credentialsFileName);
        CredentialsPersistenceManager credentialsPersistenceManager = new CredentialsPersistenceManager(credentialsFile);
        CredentialsContainer credentialsContainer = new CredentialsContainer(credentialsEncryptor, credentialsPersistenceManager.readCredentials());
        project.getExtensions().getExtraProperties().set(CREDENTIALS_CONTAINER_PROPERTY, (Object)credentialsContainer);
        LOGGER.debug("Registered property 'credentials'");
        AddCredentialsTask addCredentials = (AddCredentialsTask)project.getTasks().create(ADD_CREDENTIALS_TASK_NAME, AddCredentialsTask.class);
        addCredentials.setDescription("Adds the credentials specified through the project properties 'credentialsKey' and 'credentialsValue'.");
        addCredentials.setGroup("Credentials");
        addCredentials.setCredentialsEncryptor(credentialsEncryptor);
        addCredentials.setCredentialsPersistenceManager(credentialsPersistenceManager);
        LOGGER.debug(String.format("Registered task '%s'", addCredentials.getName()));
        RemoveCredentialsTask removeCredentials = (RemoveCredentialsTask)project.getTasks().create(REMOVE_CREDENTIALS_TASK_NAME, RemoveCredentialsTask.class);
        removeCredentials.setDescription("Removes the credentials specified through the project property 'credentialsKey'.");
        removeCredentials.setGroup("Credentials");
        removeCredentials.setCredentialsPersistenceManager(credentialsPersistenceManager);
        LOGGER.debug(String.format("Registered task '%s'", removeCredentials.getName()));
    }

    private String deriveFileNameFromPassphrase(String passphrase) {
        String credentialsFileName;
        if (passphrase.equals(DEFAULT_PASSPHRASE)) {
            credentialsFileName = DEFAULT_PASSPHRASE_CREDENTIALS_FILE;
            LOGGER.debug("No explicit passphrase provided. Using default credentials file name: " + credentialsFileName);
        } else {
            credentialsFileName = "gradle." + MD5.generateMD5Hash(passphrase) + ".encrypted.properties";
            LOGGER.debug("Custom passphrase provided. Using credentials file name: " + credentialsFileName);
        }
        return credentialsFileName;
    }

    private String getProjectProperty(String key, String defaultValue, Project project) {
        Map properties = project.getProperties();
        return properties.containsKey(key) ? (String)properties.get(key) : defaultValue;
    }
}

