/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.tokenformat;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.Token;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenOutputField;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;

public class NamedTokenParser
extends TokenParser {
    private final Pattern pattern = Pattern.compile(this.getLogFormatToken());

    public NamedTokenParser(String nLogFormatToken, String nValueName, String nValueType, EnumSet<Casts> nCasts, String nRegex) {
        this(nLogFormatToken, nValueName, nValueType, nCasts, nRegex, 0);
    }

    public NamedTokenParser(String nLogFormatToken, String nValueName, String nValueType, EnumSet<Casts> nCasts, String nRegex, int prio) {
        super(nLogFormatToken, nValueName, nValueType, nCasts, nRegex, prio);
    }

    @Override
    public Token getNextToken(String logFormat, int startOffset) {
        Matcher matcher = this.pattern.matcher(logFormat.substring(startOffset));
        if (!matcher.find()) {
            return null;
        }
        String fieldName = "";
        if (matcher.groupCount() > 0) {
            fieldName = matcher.group(1);
        }
        int start = matcher.start();
        int end = matcher.end();
        Token token = new Token(this.getRegex(), startOffset + start, end - start, this.getPrio());
        for (TokenOutputField tokenOutputField : this.getOutputFields()) {
            token.addOutputField(tokenOutputField.getType(), tokenOutputField.getName() + fieldName, tokenOutputField.getCasts());
        }
        if (this.warningMessageWhenUsed != null) {
            token.setWarningMessageWhenUsed(this.warningMessageWhenUsed.replaceFirst("\\{\\}", fieldName));
        }
        return token;
    }
}

