/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.tokenformat;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.Token;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenOutputField;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterizedTokenParser
extends TokenParser {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterizedTokenParser.class);
    private final Pattern pattern = Pattern.compile(this.getLogFormatToken());

    public ParameterizedTokenParser(String nLogFormatToken, String nValueName, String nValueType, EnumSet<Casts> nCasts, String nRegex, int prio, Dissector customDissector) {
        super(nLogFormatToken, nValueName, nValueType, nCasts, nRegex, prio, customDissector);
    }

    @Override
    public TokenParser addOutputField(String type, String name, EnumSet<Casts> casts) {
        if (this.getOutputFields().isEmpty()) {
            return super.addOutputField(type, name, casts);
        }
        throw new UnsupportedOperationException("A ParameterizedTokenParser only supports ONE outputfield.");
    }

    @Override
    public TokenParser addOutputFields(List<TokenOutputField> outputFields) {
        if (this.getOutputFields().isEmpty()) {
            return super.addOutputFields(outputFields);
        }
        throw new UnsupportedOperationException("A ParameterizedTokenParser only supports ONE outputfield.");
    }

    @Override
    public Token getNextToken(String logFormat, int startOffset) {
        Matcher matcher = this.pattern.matcher(logFormat.substring(startOffset));
        if (!matcher.find()) {
            return null;
        }
        String fieldName = "";
        if (matcher.groupCount() > 0) {
            fieldName = matcher.group(1);
        }
        int start = matcher.start();
        int end = matcher.end();
        Token token = new Token(this.getRegex(), startOffset + start, end - start, this.getPrio());
        for (TokenOutputField tokenOutputField : this.getOutputFields()) {
            String fieldType = this.tokenParameterToTypeName(fieldName);
            token.addOutputField(this.tokenParameterToTypeName(fieldName), tokenOutputField.getName(), tokenOutputField.getCasts());
            this.addCustomDissector(token, fieldType, fieldName);
        }
        if (this.warningMessageWhenUsed != null) {
            token.setWarningMessageWhenUsed(this.warningMessageWhenUsed.replaceFirst("\\{\\}", fieldName));
        }
        return token;
    }

    String tokenParameterToTypeName(String parameter) {
        return (this.getOutputFields().get(0).getType() + parameter.replaceAll("[^A-Za-z0-9]", "") + "_" + this.stringHashAsHexString(parameter)).toUpperCase(Locale.ENGLISH);
    }

    private String stringHashAsHexString(String input) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            result = Hex.encodeHexString((byte[])md.digest(input.getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return result;
    }
}

