/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.httpdlog.dissectors.TimeStampDissector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrfTimeStampDissector
extends Dissector {
    private static final Logger LOG = LoggerFactory.getLogger(StrfTimeStampDissector.class);
    List<TimeStampDissector> timeStampDissectors = new ArrayList<TimeStampDissector>(8);
    String dateTimePattern = null;
    private String inputType = "TIME.?????";

    public void setDateTimePattern(String newDateTimePattern) throws InvalidDissectorException {
        if (newDateTimePattern == null) {
            this.dateTimePattern = null;
            this.timeStampDissectors.clear();
            return;
        }
        if (newDateTimePattern.equals(this.dateTimePattern)) {
            return;
        }
        this.dateTimePattern = newDateTimePattern;
        this.timeStampDissectors.clear();
        for (String jodaPattern : this.convertStrfTimeToTimeFormat(newDateTimePattern)) {
            this.timeStampDissectors.add(new TimeStampDissector(jodaPattern));
        }
    }

    public boolean initializeFromSettingsParameter(String settings) {
        try {
            this.setDateTimePattern(settings);
        }
        catch (InvalidDissectorException e) {
            LOG.error(e.getMessage());
            return false;
        }
        return true;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(this.inputType, inputname);
        DissectionFailure exception = null;
        for (TimeStampDissector timeStampDissector : this.timeStampDissectors) {
            try {
                timeStampDissector.dissect(field, parsable, inputname);
                return;
            }
            catch (DissectionFailure df) {
                exception = df;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public String getInputType() {
        return this.inputType;
    }

    public List<String> getPossibleOutput() {
        return this.timeStampDissectors.get(0).getPossibleOutput();
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        EnumSet result = Casts.STRING_ONLY;
        for (Dissector dissector : this.timeStampDissectors) {
            result = dissector.prepareForDissect(inputname, outputname);
        }
        return result;
    }

    public void prepareForRun() throws InvalidDissectorException {
        for (Dissector dissector : this.timeStampDissectors) {
            dissector.prepareForRun();
        }
    }

    protected void initializeNewInstance(Dissector newInstance) throws InvalidDissectorException {
        StrfTimeStampDissector newStrfTimeStampDissector = (StrfTimeStampDissector)newInstance;
        newStrfTimeStampDissector.setInputType(this.getInputType());
        newStrfTimeStampDissector.setDateTimePattern(this.dateTimePattern);
    }

    public void setInputType(String newInputType) {
        this.inputType = newInputType;
    }

    List<String> convertStrfTimeToTimeFormat(String strftime) throws InvalidDissectorException {
        List<String> resultSet = new ArrayList<String>();
        strftime = strftime.replaceAll("begin:", "").replaceAll("end:", "");
        resultSet.add(strftime);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%%", "'%'");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%n", "'\n'");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%t", "'\t'");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%E", "%");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%O", "%");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%D", "%m/%d/%y");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%F", "%Y-%m-%d");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%R", "%H:%M");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%T", "%H:%M:%S");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%r", "%I:%M:%S %p");
        ArrayList<String> quotedResultSet = new ArrayList<String>();
        for (String result : resultSet) {
            result = result.replaceAll("(%.)", "'$1'");
            result = result.replaceAll("msec_frac", "'SSS'");
            result = result.replaceAll("''", "");
            result = result.replaceAll("^'(%.)", "$1");
            result = result.replaceAll("(%.)'$", "$1");
            quotedResultSet.add(result);
        }
        resultSet = quotedResultSet;
        resultSet = this.mapStrftimeToJodatime(resultSet, "%s", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%P", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%w", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%U", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%V", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%W", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%c", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%x", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%X", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%Z", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%+", new String[0]);
        resultSet = this.mapStrftimeToJodatime(resultSet, "%a", "EEE");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%A", "EEEE");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%b", "MMM");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%B", "MMMM");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%C", "CC");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%d", "dd");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%G", "xxxx");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%g", "xx");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%h", "MMM");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%H", "HH");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%I", "hh");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%j", "DDD");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%m", "MM");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%M", "mm");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%p", "a");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%S", "ss");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%u", "e");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%Y", "yyyy");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%y", "yy");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%z", "ZZ");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%k", "HH", " H");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%l", "hh", " h");
        resultSet = this.mapStrftimeToJodatime(resultSet, "%e", "dd", " d");
        return resultSet;
    }

    private List<String> mapStrftimeToJodatime(List<String> dateTimeFormats, String strftimeField, String ... jodaFields) throws InvalidDissectorException {
        ArrayList<String> result = new ArrayList<String>(dateTimeFormats.size());
        for (String dateTimeFormat : dateTimeFormats) {
            if (dateTimeFormat.contains(strftimeField)) {
                if (jodaFields.length == 0) {
                    throw new InvalidDissectorException("Unsupported strfime parameter '" + strftimeField + "' (cannot be mapped to jodatime).");
                }
                for (String jodaField : jodaFields) {
                    result.add(dateTimeFormat.replaceAll(strftimeField, jodaField));
                }
                continue;
            }
            result.add(dateTimeFormat);
        }
        return result;
    }

    public <RECORD> void createAdditionalDissectors(Parser<RECORD> parser) {
        parser.addDissector((Dissector)new LocalizedTimeDissector(this.inputType));
    }

    public static class LocalizedTimeDissector
    extends Dissector {
        String inputType = null;

        public LocalizedTimeDissector() {
        }

        public LocalizedTimeDissector(String inputType) {
            this.inputType = inputType;
        }

        public void setInputType(String newInputType) {
            this.inputType = newInputType;
        }

        public boolean initializeFromSettingsParameter(String settings) {
            this.setInputType(settings);
            return true;
        }

        public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
            ParsedField field = parsable.getParsableField(this.inputType, inputname);
            parsable.addDissection(inputname, "TIME.LOCALIZEDSTRING", "", field.getValue());
        }

        public String getInputType() {
            return this.inputType;
        }

        public List<String> getPossibleOutput() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("TIME.LOCALIZEDSTRING:");
            return result;
        }

        public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
            return Casts.STRING_ONLY;
        }

        public void prepareForRun() throws InvalidDissectorException {
        }

        protected void initializeNewInstance(Dissector newInstance) throws InvalidDissectorException {
            newInstance.setInputType(this.inputType);
        }
    }
}

