/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.NamedTokenParser;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenFormatDissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NginxHttpdLogFormatDissector
extends TokenFormatDissector {
    private static final Logger LOG = LoggerFactory.getLogger(NginxHttpdLogFormatDissector.class);

    public NginxHttpdLogFormatDissector(String logFormat) {
        super(logFormat);
        this.setInputType("HTTPLOGLINE");
    }

    public NginxHttpdLogFormatDissector() {
        this.setInputType("HTTPLOGLINE");
    }

    private void overrideLogFormat(String originalLogformat, String logformat) {
        LOG.debug("Specified logformat \"{}\" was mapped to {}", (Object)originalLogformat, (Object)logformat);
        super.setLogFormat(logformat);
    }

    @Override
    public void setLogFormat(String logformat) {
        switch (logformat.toLowerCase(Locale.getDefault())) {
            case "combined": {
                this.overrideLogFormat(logformat, "$remote_addr - $remote_user [$time_local] \"$request\" $status $body_bytes_sent \"$http_referer\" \"$http_user_agent\"");
                break;
            }
            default: {
                super.setLogFormat(logformat);
            }
        }
    }

    protected String makeHeaderNamesLowercaseInLogFormat(String logformat) {
        StringBuffer sb = new StringBuffer(logformat.length());
        Pattern p = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher m = p.matcher(logformat);
        while (m.find()) {
            m.appendReplacement(sb, '{' + m.group(1).toLowerCase() + '}');
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    protected String cleanupLogFormat(String tokenLogFormat) {
        return this.makeHeaderNamesLowercaseInLogFormat(tokenLogFormat);
    }

    @Override
    public String decodeExtractedValue(String tokenName, String value) {
        if (value == null || value.equals("")) {
            return value;
        }
        if (value.equals("-")) {
            return null;
        }
        return value;
    }

    @Override
    protected List<TokenParser> createAllTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>(60);
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$bytes_sent"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$connection"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$connection_requests"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$msec"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$pipe"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request_length"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request_time"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$status"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$time_iso8601"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$time_local"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$arg_name"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$args"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$query_string"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$binary_remote_addr"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$body_bytes_sent"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$bytes_sent"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$connection"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$connection_requests"));
        parsers.add(new TokenParser("\\%\\{([a-z0-9\\-_]*)\\}i", "request.header.content_length", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$content_type", "request.cookies.content-type", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new NamedTokenParser("$cookie_([a-z0-9\\-_]*)", "request.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$document_root"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$host"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$hostname"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}i", "request.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$https"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$is_args"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$limit_rate"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$msec"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$nginx_version"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$pid"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$pipe"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$proxy_protocol_addr"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$realpath_root"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$remote_addr"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$remote_port"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$remote_user"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request"));
        parsers.add(new TokenParser("%r", "request.firstline", "HTTP.FIRSTLINE", Casts.STRING_ONLY, "[^\\s]* [^\\s]* [^\\s]*"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request_body"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request_body_file"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request_completion"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request_filename"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request_length"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request_method"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request_time"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$request_uri"));
        parsers.add(new TokenParser("$scheme", "request.firstline.uri.protocol", "HTTP.PROTOCOL", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$sent_http_name"));
        parsers.add(new TokenParser("$server_addr", "connection.server.ip", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.add(new TokenParser("$server_name", "connection.server.name", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$server_port", "connection.server.port", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$server_protocol"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$status"));
        parsers.add(new TokenParser("%s", "request.status.original", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$tcpinfo_rtt"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$tcpinfo_rttvar"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$tcpinfo_snd_cwnd"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$tcpinfo_rcv_space"));
        parsers.add(new TokenParser("%t", "request.receive.time", "TIME.STAMP", Casts.STRING_ONLY, "[0-3][0-9]/(?:[A-Z][a-z][a-z])/[1-9][0-9][0-9][0-9]:[0-9][0-9]:[0-9][0-9]:[0-9][0-9] [\\+|\\-][0-9][0-9][0-9][0-9]"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$time_local"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$uri"));
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("$document_uri"));
        parsers.add(new TokenParser("%{cookie}i", "request.cookies", "HTTP.COOKIES", Casts.STRING_ONLY, ".*", 1));
        parsers.add(new TokenParser("%{set-cookie}o", "response.cookies", "HTTP.SETCOOKIES", Casts.STRING_ONLY, ".*", 1));
        parsers.add(new TokenParser("%{user-agent}i", "request.user-agent", "HTTP.USERAGENT", Casts.STRING_ONLY, ".*", 1));
        parsers.add(new TokenParser("%{referer}i", "request.referer", "HTTP.URI", Casts.STRING_ONLY, "[^\\s]*", 1));
        return parsers;
    }
}

