/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public final class Utils {
    private static final Pattern VALID_STANDARD = Pattern.compile("%([0-9A-Fa-f]{2})");
    private static final Pattern CHOPPED_STANDARD = Pattern.compile("%[0-9A-Fa-f]?$");
    private static final Pattern VALID_NON_STANDARD = Pattern.compile("%u([0-9A-Fa-f][0-9A-Fa-f])([0-9A-Fa-f][0-9A-Fa-f])");
    private static final Pattern CHOPPED_NON_STANDARD = Pattern.compile("%u[0-9A-Fa-f]{0,3}$");

    private Utils() {
    }

    public static String resilientUrlDecode(String input) {
        String cookedInput = input;
        if (cookedInput.indexOf(37) > -1) {
            cookedInput = VALID_STANDARD.matcher(cookedInput).replaceAll("%00%$1");
            if ((cookedInput = CHOPPED_STANDARD.matcher(cookedInput).replaceAll("")).contains("%u")) {
                cookedInput = VALID_NON_STANDARD.matcher(cookedInput).replaceAll("%$1%$2");
                cookedInput = CHOPPED_NON_STANDARD.matcher(cookedInput).replaceAll("");
            }
        }
        try {
            return URLDecoder.decode(cookedInput, "UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

