/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.http.disectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Disector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeStampDisector
extends Disector {
    private DateTimeFormatter formatter;
    private String dateTimePattern;
    private static final String INPUT_TYPE = "TIME.STAMP";
    private boolean wantDay = false;
    private boolean wantMonthname = false;
    private boolean wantMonth = false;
    private boolean wantWeekOfWeekYear = false;
    private boolean wantWeekYear = false;
    private boolean wantYear = false;
    private boolean wantHour = false;
    private boolean wantMinute = false;
    private boolean wantSecond = false;
    private boolean wantMillisecond = false;
    private boolean wantTimezone = false;
    private boolean wantEpoch = false;

    public TimeStampDisector() {
        this.setDateTimePattern("[dd/MMM/yyyy:HH:mm:ss ZZ]");
    }

    public TimeStampDisector(String newDateTimePattern) {
        this.setDateTimePattern(newDateTimePattern);
    }

    public void setDateTimePattern(String newDateTimePattern) {
        this.dateTimePattern = newDateTimePattern;
        this.formatter = DateTimeFormat.forPattern((String)this.dateTimePattern);
    }

    protected void initializeNewInstance(Disector newInstance) {
        ((TimeStampDisector)newInstance).setDateTimePattern(this.dateTimePattern);
    }

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("TIME.DAY:day");
        result.add("TIME.MONTHNAME:monthname");
        result.add("TIME.MONTH:month");
        result.add("TIME.WEEK:weekofweekyear");
        result.add("TIME.YEAR:weekyear");
        result.add("TIME.YEAR:year");
        result.add("TIME.HOUR:hour");
        result.add("TIME.MINUTE:minute");
        result.add("TIME.SECOND:second");
        result.add("TIME.MILLISECOND:millisecond");
        result.add("TIME.ZONE:timezone");
        result.add("TIME.EPOCH:epoch");
        return result;
    }

    public EnumSet<Casts> prepareForDisect(String inputname, String outputname) {
        String name;
        switch (name = outputname.substring(inputname.length() + 1)) {
            case "day": {
                this.wantDay = true;
                return Casts.STRING_OR_LONG;
            }
            case "monthname": {
                this.wantMonthname = true;
                return Casts.STRING_ONLY;
            }
            case "month": {
                this.wantMonth = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekofweekyear": {
                this.wantWeekOfWeekYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "weekyear": {
                this.wantWeekYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "year": {
                this.wantYear = true;
                return Casts.STRING_OR_LONG;
            }
            case "hour": {
                this.wantHour = true;
                return Casts.STRING_OR_LONG;
            }
            case "minute": {
                this.wantMinute = true;
                return Casts.STRING_OR_LONG;
            }
            case "second": {
                this.wantSecond = true;
                return Casts.STRING_OR_LONG;
            }
            case "millisecond": {
                this.wantMillisecond = true;
                return Casts.STRING_OR_LONG;
            }
            case "timezone": {
                this.wantTimezone = true;
                return Casts.STRING_ONLY;
            }
            case "epoch": {
                this.wantEpoch = true;
                return Casts.STRING_OR_LONG;
            }
        }
        return null;
    }

    public void prepareForRun() {
    }

    public void disect(Parsable<?> parsable, String inputname) {
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        DateTime dateTime = this.formatter.parseDateTime(fieldValue);
        if (this.wantDay) {
            parsable.addDisection(inputname, "TIME.DAY", "day", dateTime.dayOfMonth().getAsString());
        }
        if (this.wantMonthname) {
            parsable.addDisection(inputname, "TIME.MONTHNAME", "monthname", dateTime.monthOfYear().getAsText(Locale.getDefault()));
        }
        if (this.wantMonth) {
            parsable.addDisection(inputname, "TIME.MONTH", "month", dateTime.monthOfYear().getAsString());
        }
        if (this.wantWeekOfWeekYear) {
            parsable.addDisection(inputname, "TIME.WEEK", "weekofweekyear", dateTime.weekOfWeekyear().getAsString());
        }
        if (this.wantWeekYear) {
            parsable.addDisection(inputname, "TIME.YEAR", "weekyear", dateTime.weekyear().getAsString());
        }
        if (this.wantYear) {
            parsable.addDisection(inputname, "TIME.YEAR", "year", dateTime.year().getAsString());
        }
        if (this.wantHour) {
            parsable.addDisection(inputname, "TIME.HOUR", "hour", dateTime.hourOfDay().getAsString());
        }
        if (this.wantMinute) {
            parsable.addDisection(inputname, "TIME.MINUTE", "minute", dateTime.minuteOfHour().getAsString());
        }
        if (this.wantSecond) {
            parsable.addDisection(inputname, "TIME.SECOND", "second", dateTime.secondOfMinute().getAsString());
        }
        if (this.wantMillisecond) {
            parsable.addDisection(inputname, "TIME.MILLISECOND", "millisecond", dateTime.millisOfSecond().getAsString());
        }
        if (this.wantTimezone) {
            parsable.addDisection(inputname, "TIME.TIMEZONE", "timezone", dateTime.getZone().getID());
        }
        if (this.wantEpoch) {
            parsable.addDisection(inputname, "TIME.EPOCH", "epoch", Long.toString(dateTime.getMillis()));
        }
    }
}

