/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.collections.prefixmap;

import java.io.Serializable;
import java.util.TreeMap;
import nl.basjes.collections.prefixmap.PrefixTrie;

class StringPrefixTrie<V extends Serializable>
implements PrefixTrie<V> {
    protected TreeMap<Character, PrefixTrie<V>> childNodes;
    private boolean caseSensitive;
    private int charIndex;
    private V theValue;

    private StringPrefixTrie() {
    }

    StringPrefixTrie(boolean caseSensitive) {
        this(caseSensitive, 0);
    }

    StringPrefixTrie(boolean caseSensitive, int charIndex) {
        this.caseSensitive = caseSensitive;
        this.charIndex = charIndex;
    }

    @Override
    public V add(String prefix, V value) {
        if (prefix == null) {
            throw new NullPointerException("The prefix may not be null");
        }
        if (value == null) {
            throw new NullPointerException("The value may not be null");
        }
        V previousValue = this.theValue;
        if (this.charIndex == prefix.length()) {
            this.theValue = value;
            return previousValue;
        }
        char myChar = prefix.charAt(this.charIndex);
        if (this.childNodes == null) {
            this.childNodes = new TreeMap();
        }
        if (this.caseSensitive) {
            PrefixTrie child = this.childNodes.computeIfAbsent(Character.valueOf(myChar), c -> new StringPrefixTrie<V>(true, this.charIndex + 1));
            previousValue = child.add(prefix, value);
        } else {
            char lower = Character.toLowerCase(myChar);
            char upper = Character.toUpperCase(myChar);
            PrefixTrie child = this.childNodes.computeIfAbsent(Character.valueOf(lower), c -> new StringPrefixTrie<V>(false, this.charIndex + 1));
            previousValue = child.add(prefix, value);
            this.childNodes.put(Character.valueOf(upper), child);
        }
        return previousValue;
    }

    @Override
    public V remove(String prefix) {
        PrefixTrie<V> child;
        if (prefix == null) {
            throw new NullPointerException("The prefix may not be null");
        }
        if (this.charIndex == prefix.length()) {
            V previousValue = this.theValue;
            this.theValue = null;
            return previousValue;
        }
        if (this.childNodes == null) {
            return null;
        }
        char myChar = prefix.charAt(this.charIndex);
        if (!this.caseSensitive) {
            myChar = Character.toLowerCase(myChar);
        }
        if ((child = this.childNodes.get(Character.valueOf(myChar))) == null) {
            return null;
        }
        return child.remove(prefix);
    }

    @Override
    public boolean containsPrefix(String prefix) {
        if (this.charIndex == prefix.length()) {
            return this.theValue != null;
        }
        if (this.childNodes == null) {
            return false;
        }
        char myChar = prefix.charAt(this.charIndex);
        PrefixTrie<V> child = this.childNodes.get(Character.valueOf(myChar));
        if (child == null) {
            return false;
        }
        return child.containsPrefix(prefix);
    }

    @Override
    public V getShortestMatch(String input) {
        if (this.theValue != null || this.charIndex == input.length() || this.childNodes == null) {
            return this.theValue;
        }
        char myChar = input.charAt(this.charIndex);
        PrefixTrie<V> child = this.childNodes.get(Character.valueOf(myChar));
        if (child == null) {
            return null;
        }
        return child.getShortestMatch(input);
    }

    @Override
    public V getLongestMatch(String input) {
        if (this.charIndex == input.length() || this.childNodes == null) {
            return this.theValue;
        }
        char myChar = input.charAt(this.charIndex);
        PrefixTrie<V> child = this.childNodes.get(Character.valueOf(myChar));
        if (child == null) {
            return this.theValue;
        }
        V returnValue = child.getLongestMatch(input);
        return returnValue == null ? this.theValue : returnValue;
    }

    @Override
    public void clear() {
        this.childNodes = null;
        this.theValue = null;
    }
}

