/*
 * Decompiled with CFR 0.152.
 */
package ng.shoppi.androidfrontend.util;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.text.TextUtils;
import android.widget.EditText;
import android.widget.ProgressBar;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import ng.shoppi.androidfrontend.R;

public class Utility {
    public static boolean isEmailValid(String email) {
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    public static boolean isPasswordValid(String password) {
        return password.length() > 4;
    }

    public static boolean validateInput(EditText editTextEmail, EditText editTextPassword, boolean emailValidation) {
        Context context = editTextEmail.getContext();
        editTextEmail.setError(null);
        editTextPassword.setError(null);
        String email = editTextEmail.getText().toString().trim();
        String password = editTextPassword.getText().toString().trim();
        boolean cancel = false;
        EditText focusView = null;
        if (TextUtils.isEmpty((CharSequence)password) || !Utility.isPasswordValid(password)) {
            editTextPassword.setError((CharSequence)context.getResources().getString(R.string.error_invalid_password));
            focusView = editTextPassword;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)email)) {
            editTextEmail.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
            focusView = editTextEmail;
            cancel = true;
        } else if (emailValidation && !Utility.isEmailValid(email)) {
            editTextEmail.setError((CharSequence)context.getResources().getString(R.string.error_invalid_email));
            focusView = editTextEmail;
            cancel = true;
        }
        if (cancel) {
            focusView.requestFocus();
            return false;
        }
        return true;
    }

    public static void showProgressBar(final boolean show, final ProgressBar progressBar) {
        Context context = progressBar.getContext();
        int shortAnimTime = context.getResources().getInteger(0x10E0000);
        progressBar.setVisibility(show ? 0 : 8);
        progressBar.animate().setDuration((long)shortAnimTime).alpha(show ? 1.0f : 0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                progressBar.setVisibility(show ? 0 : 8);
            }
        });
    }

    public static boolean validateInput(EditText editTextFirstname, EditText editTextLastname, EditText editTextEmail, EditText editTextPassword, EditText editTextConfirmPassword, EditText editTextPhone, boolean emailValidation) {
        Context context = editTextEmail.getContext();
        editTextFirstname.setError(null);
        editTextLastname.setError(null);
        editTextEmail.setError(null);
        editTextPassword.setError(null);
        editTextConfirmPassword.setError(null);
        editTextPhone.setError(null);
        String firstName = editTextFirstname.getText().toString().trim();
        String lastName = editTextLastname.getText().toString().trim();
        String email = editTextEmail.getText().toString().trim();
        String password = editTextPassword.getText().toString();
        String confirmPassword = editTextConfirmPassword.getText().toString();
        String phone = editTextPhone.getText().toString().trim();
        boolean cancel = false;
        EditText focusView = null;
        if (TextUtils.isEmpty((CharSequence)firstName)) {
            editTextFirstname.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
            focusView = editTextFirstname;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)lastName)) {
            editTextLastname.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
            focusView = editTextLastname;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)password) || !Utility.isPasswordValid(password)) {
            editTextPassword.setError((CharSequence)context.getResources().getString(R.string.error_invalid_password));
            focusView = editTextPassword;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)confirmPassword) || !Utility.isPasswordValid(confirmPassword)) {
            editTextConfirmPassword.setError((CharSequence)context.getResources().getString(R.string.error_invalid_password));
            focusView = editTextConfirmPassword;
            cancel = true;
        }
        if (!password.equals(confirmPassword)) {
            editTextPassword.setError((CharSequence)context.getResources().getString(R.string.error_password_mismatch));
            focusView = editTextPassword;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)email)) {
            editTextEmail.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
            focusView = editTextEmail;
            cancel = true;
        } else if (emailValidation && !Utility.isEmailValid(email)) {
            editTextEmail.setError((CharSequence)context.getResources().getString(R.string.error_invalid_email));
            focusView = editTextEmail;
            cancel = true;
        }
        if (phone.isEmpty()) {
            editTextPhone.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
            focusView = editTextPhone;
            cancel = true;
        }
        if (phone.length() != 11) {
            editTextPhone.setError((CharSequence)context.getResources().getString(R.string.error_phone_incomplete));
            focusView = editTextPhone;
            cancel = true;
        }
        if (cancel) {
            focusView.requestFocus();
            return false;
        }
        return true;
    }
}

