/*
 * Decompiled with CFR 0.152.
 */
package ng.shoppi.androidfrontend.recycleradapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.Map;
import ng.shoppi.androidfrontend.R;
import ng.shoppi.androidfrontend.listeners.OnRecyclerClickListener;

public class CustomRecyclerAdapterB
extends RecyclerView.Adapter<RecyclerViewHolder> {
    private Context context;
    private ArrayList<Map<String, String>> items;
    private OnRecyclerClickListener onRecyclerClickListener;
    private boolean loadImage;
    public static final String IMAGE_URL = "image_url";
    public static final String TITLE = "title";
    public static final String TIMES_TAMP = "times_tamp";

    public CustomRecyclerAdapterB(Context context, ArrayList<Map<String, String>> items, boolean loadImage) {
        this.context = context;
        this.items = items;
        this.onRecyclerClickListener = (OnRecyclerClickListener)context;
        this.loadImage = loadImage;
    }

    public RecyclerViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.lib_shopping_recycler_item_2, parent, false);
        return new RecyclerViewHolder(v);
    }

    public void onBindViewHolder(RecyclerViewHolder holder, int position) {
        Map<String, String> item = this.items.get(position);
        if (this.loadImage) {
            Picasso.with((Context)this.context).load(item.get(IMAGE_URL)).into(holder.imageViewAvatar);
        }
        holder.textViewAlertMessage.setText((CharSequence)item.get(TITLE));
        holder.textViewAlertTime.setText((CharSequence)item.get(TIMES_TAMP));
    }

    public int getItemCount() {
        return this.items.size();
    }

    class RecyclerViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnLongClickListener {
        private ImageView imageViewAvatar;
        private TextView textViewAlertMessage;
        private TextView textViewAlertTime;

        RecyclerViewHolder(View itemView) {
            super(itemView);
            this.imageViewAvatar = (ImageView)itemView.findViewById(R.id.imageViewMessageIcon);
            this.textViewAlertMessage = (TextView)itemView.findViewById(R.id.textViewAlertMessage);
            this.textViewAlertTime = (TextView)itemView.findViewById(R.id.textViewAlertTime);
            itemView.setOnClickListener((View.OnClickListener)this);
            itemView.setOnLongClickListener((View.OnLongClickListener)this);
            this.imageViewAvatar.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CustomRecyclerAdapterB.this.onRecyclerClickListener.onImageClick(RecyclerViewHolder.this.getAdapterPosition());
                }
            });
        }

        public void onClick(View v) {
            CustomRecyclerAdapterB.this.onRecyclerClickListener.onItemClick(this.getAdapterPosition());
        }

        public boolean onLongClick(View view) {
            return CustomRecyclerAdapterB.this.onRecyclerClickListener.onItemLongClick(this.getAdapterPosition());
        }
    }
}

