/*
 * Decompiled with CFR 0.152.
 */
package ng.shoppi.androidfrontend.recycleradapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.ArrayList;
import java.util.Map;
import ng.shoppi.androidfrontend.R;
import ng.shoppi.androidfrontend.listeners.OnRecyclerClickListener;

public class CustomRecyclerAdapterA
extends RecyclerView.Adapter<RecyclerViewHolder> {
    private Context context;
    private ArrayList<Map<String, String>> items;
    private OnRecyclerClickListener onRecyclerClickListener;
    private boolean loadImage;
    public static final String IMAGE_URL = "image_url";
    public static final String NAME = "name";
    public static final String ADDRESS = "address";

    public CustomRecyclerAdapterA(Context context, ArrayList<Map<String, String>> items, boolean loadImage) {
        this.context = context;
        this.items = items;
        this.onRecyclerClickListener = (OnRecyclerClickListener)context;
        this.loadImage = loadImage;
    }

    public RecyclerViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.lib_shopping_recycler_item_1, parent, false);
        return new RecyclerViewHolder(v);
    }

    public void onBindViewHolder(RecyclerViewHolder holder, int position) {
        Map<String, String> item = this.items.get(position);
        if (this.loadImage) {
            Picasso.with((Context)this.context).load(item.get(IMAGE_URL)).into((ImageView)holder.imageViewAvatar);
        }
        holder.textViewObjectName.setText((CharSequence)item.get(NAME));
        holder.textViewObjectAddress.setText((CharSequence)item.get(ADDRESS));
    }

    public int getItemCount() {
        return this.items.size();
    }

    class RecyclerViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnLongClickListener {
        private CircleImageView imageViewAvatar;
        private TextView textViewObjectName;
        private TextView textViewObjectAddress;

        RecyclerViewHolder(View itemView) {
            super(itemView);
            this.imageViewAvatar = (CircleImageView)itemView.findViewById(R.id.imageViewAvatar);
            this.textViewObjectName = (TextView)itemView.findViewById(R.id.textViewObjectName);
            this.textViewObjectAddress = (TextView)itemView.findViewById(R.id.textViewObjectAddress);
            itemView.setOnClickListener((View.OnClickListener)this);
            itemView.setOnLongClickListener((View.OnLongClickListener)this);
            this.imageViewAvatar.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CustomRecyclerAdapterA.this.onRecyclerClickListener.onImageClick(RecyclerViewHolder.this.getAdapterPosition());
                }
            });
        }

        public void onClick(View v) {
            CustomRecyclerAdapterA.this.onRecyclerClickListener.onItemClick(this.getAdapterPosition());
        }

        public boolean onLongClick(View view) {
            return CustomRecyclerAdapterA.this.onRecyclerClickListener.onItemLongClick(this.getAdapterPosition());
        }
    }
}

