/*
 * Decompiled with CFR 0.152.
 */
package ng.shoppi.androidfrontend.genericformhandler;

import android.content.Context;
import android.view.View;
import android.widget.EditText;
import android.widget.ProgressBar;
import ng.shoppi.androidfrontend.listeners.LoginOnClickListener;
import ng.shoppi.androidfrontend.models.User;
import ng.shoppi.androidfrontend.util.Utility;

public class LoginHandler {
    private View forgotPassword;
    private View register;
    private EditText editTextPassword;
    private View signIn;
    private boolean emailValidation;
    private EditText editTextEmail;
    private ProgressBar progressBar;
    private LoginOnClickListener loginOnClickListener;

    public LoginHandler(EditText username, EditText password, View signIn, ProgressBar progressBar, boolean emailValidation) {
        this.editTextEmail = username;
        this.editTextPassword = password;
        this.signIn = signIn;
        this.progressBar = progressBar;
        this.emailValidation = emailValidation;
        this.setUp();
    }

    public LoginHandler(EditText username, EditText password, View signIn, ProgressBar progressBar, View register, boolean emailValidation) {
        this.editTextEmail = username;
        this.editTextPassword = password;
        this.signIn = signIn;
        this.progressBar = progressBar;
        this.register = register;
        this.emailValidation = emailValidation;
        this.setUp();
    }

    public LoginHandler(EditText username, EditText password, View signIn, ProgressBar progressBar, View register, View forgotPassword, boolean emailValidation) {
        this.editTextEmail = username;
        this.editTextPassword = password;
        this.signIn = signIn;
        this.progressBar = progressBar;
        this.register = register;
        this.emailValidation = emailValidation;
        this.forgotPassword = forgotPassword;
        this.setUp();
    }

    private void setUp() {
        Context context = this.editTextEmail.getContext();
        this.loginOnClickListener = (LoginOnClickListener)context;
        this.signIn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginHandler.this.loginOnClickListener.onSignInClick();
            }
        });
        if (this.register != null) {
            this.register.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    LoginHandler.this.loginOnClickListener.onSignUpClick();
                }
            });
        }
        if (this.forgotPassword != null) {
            this.forgotPassword.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    LoginHandler.this.loginOnClickListener.onForgetPasswordClick();
                }
            });
        }
    }

    public boolean validateInput() {
        return Utility.validateInput(this.editTextEmail, this.editTextPassword, this.emailValidation);
    }

    public void showProgressBar(boolean show) {
        Utility.showProgressBar(show, this.progressBar);
    }

    public User getUser() {
        return new User(this.editTextEmail.getText().toString(), this.editTextPassword.getText().toString());
    }
}

