/*
 * Decompiled with CFR 0.152.
 */
package ng.shoppi.androidfrontend.forms;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatSpinner;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import ng.shoppi.androidfrontend.R;
import ng.shoppi.androidfrontend.listeners.RegistrationOnClickListener;
import ng.shoppi.androidfrontend.models.User;
import ng.shoppi.androidfrontend.util.Utility;

public class RegForm
extends RelativeLayout {
    private ImageView backgroundImageView;
    private ImageView imageView;
    private EditText editTextFirstName;
    private EditText editTextLastName;
    private EditText editTextEmail;
    private EditText editTextPassword;
    private EditText editTextConfirmPassword;
    private EditText editTextPhone;
    private EditText editTextAddress;
    private RadioGroup radioGroupGender;
    private AppCompatSpinner appCompatMaritalStatus;
    private TextView editTextReligion;
    private Button buttonRegister;
    private ProgressBar progressBar;
    private TextView textViewLogin;
    private RelativeLayout relativeLayoutBackgroundColor;
    private LinearLayout linearLayoutRegForm;
    private LinearLayout phoneLayout;
    private LinearLayout addressLayout;
    private LinearLayout genderLayout;
    private LinearLayout maritalStatusLayout;
    private LinearLayout religionLayout;
    private boolean validateEmail;
    private String maritalStatus = "Unknown";
    private String gender = "Male";
    private RegistrationOnClickListener registrationOnClickListener;

    public RegForm(Context context) {
        super(context);
        this.initViews(null);
    }

    public RegForm(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViews(attrs);
    }

    public RegForm(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews(attrs);
    }

    public RegForm(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initViews(attrs);
    }

    private void initViews(@Nullable AttributeSet attributeSet) {
        final View view = RegForm.inflate((Context)this.getContext(), (int)R.layout.lib_shopping_register_1, null);
        if (attributeSet == null) {
            this.addView(view);
            return;
        }
        this.relativeLayoutBackgroundColor = (RelativeLayout)view.findViewById(R.id.background_color_risk);
        this.backgroundImageView = (ImageView)view.findViewById(R.id.backgroundImage_register_risk);
        this.imageView = (ImageView)view.findViewById(R.id.imageViewLogo);
        this.editTextFirstName = (EditText)view.findViewById(R.id.editTextFirstName);
        this.editTextLastName = (EditText)view.findViewById(R.id.editTextLastName);
        this.editTextEmail = (EditText)view.findViewById(R.id.editTextEmail_risk);
        this.editTextPassword = (EditText)view.findViewById(R.id.editTextPassword_risk);
        this.editTextConfirmPassword = (EditText)view.findViewById(R.id.editTextConfirmPassword_risk);
        this.editTextPhone = (EditText)view.findViewById(R.id.editTextPhone_risk);
        this.editTextAddress = (EditText)view.findViewById(R.id.editTextAddress_risk);
        this.radioGroupGender = (RadioGroup)view.findViewById(R.id.radioGroupGender_risk);
        this.appCompatMaritalStatus = (AppCompatSpinner)view.findViewById(R.id.appCompatSpinnerMaritalStatus);
        this.editTextReligion = (TextView)view.findViewById(R.id.editTextReligion);
        this.buttonRegister = (Button)view.findViewById(R.id.buttonRegister_risk);
        this.textViewLogin = (TextView)view.findViewById(R.id.textViewLogin_risk);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progressBarSignIn_risk);
        this.linearLayoutRegForm = (LinearLayout)view.findViewById(R.id.linearLayoutRegisterForm);
        this.phoneLayout = (LinearLayout)view.findViewById(R.id.phone_layout_risk);
        this.genderLayout = (LinearLayout)view.findViewById(R.id.gender_layout_risk);
        this.addressLayout = (LinearLayout)view.findViewById(R.id.address_layout_risk);
        this.maritalStatusLayout = (LinearLayout)view.findViewById(R.id.marital_status_layout_risk);
        this.religionLayout = (LinearLayout)view.findViewById(R.id.religion_layout_risk);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.RegForm);
        Drawable backgroundDrawable = typedArray.getDrawable(R.styleable.RegForm_reg_background_image);
        int backgroundColor = typedArray.getColor(R.styleable.RegForm_reg_background_color, this.getResources().getColor(R.color.lib_shopping_purple));
        Drawable logoDrawable = typedArray.getDrawable(R.styleable.RegForm_reg_logo);
        String userIdLabel = typedArray.getString(R.styleable.RegForm_reg_user_id);
        String signInLabel = typedArray.getString(R.styleable.RegForm_reg_sign_in_label);
        String signUpLabel = typedArray.getString(R.styleable.RegForm_reg_sign_up_label);
        boolean genderVisible = typedArray.getBoolean(R.styleable.RegForm_reg_gender_visible, true);
        boolean maritalStatusVisible = typedArray.getBoolean(R.styleable.RegForm_reg_marital_status_visible, true);
        boolean addressVisible = typedArray.getBoolean(R.styleable.RegForm_reg_address_visible, true);
        boolean phoneVisible = typedArray.getBoolean(R.styleable.RegForm_reg_phone_visible, true);
        boolean religionVisible = typedArray.getBoolean(R.styleable.RegForm_reg_religion_visible, true);
        this.validateEmail = typedArray.getBoolean(R.styleable.RegForm_reg_validate_email, true);
        if (userIdLabel != null && !userIdLabel.equals("")) {
            this.editTextEmail.setHint((CharSequence)userIdLabel);
        }
        if (signInLabel != null && !signInLabel.equals("")) {
            this.textViewLogin.setText((CharSequence)signInLabel);
        }
        if (signUpLabel != null && !signUpLabel.equals("")) {
            this.buttonRegister.setText((CharSequence)signUpLabel);
        }
        if (logoDrawable != null) {
            this.imageView.setImageDrawable(logoDrawable);
        }
        if (backgroundDrawable != null) {
            this.backgroundImageView.setImageDrawable(backgroundDrawable);
        }
        this.relativeLayoutBackgroundColor.setBackgroundColor(backgroundColor);
        if (!genderVisible) {
            this.genderLayout.setVisibility(8);
        }
        if (!maritalStatusVisible) {
            this.maritalStatusLayout.setVisibility(8);
        }
        if (!addressVisible) {
            this.addressLayout.setVisibility(8);
        }
        if (!religionVisible) {
            this.religionLayout.setVisibility(8);
        }
        if (!phoneVisible) {
            this.phoneLayout.setVisibility(8);
        }
        this.appCompatMaritalStatus.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                RegForm.this.maritalStatus = RegForm.this.appCompatMaritalStatus.getSelectedItem().toString();
                ((TextView)RegForm.this.appCompatMaritalStatus.getChildAt(0)).setTextColor(-1);
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
        this.radioGroupGender.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int i) {
                int selectedId = radioGroup.getCheckedRadioButtonId();
                RadioButton radioButton = (RadioButton)view.findViewById(selectedId);
                RegForm.this.gender = radioButton.getText().toString();
            }
        });
        this.addView(view);
        typedArray.recycle();
    }

    public User getUser() {
        User user = new User(this.editTextFirstName.getText().toString(), this.editTextLastName.getText().toString(), this.editTextEmail.getText().toString(), this.editTextPassword.getText().toString());
        if (this.phoneLayout.getVisibility() != 8) {
            user.setPhoneNumber(this.editTextPhone.getText().toString());
        }
        if (this.addressLayout.getVisibility() != 8) {
            user.setAddress(this.editTextAddress.getText().toString());
        }
        if (this.genderLayout.getVisibility() != 8) {
            user.setGender(this.gender);
        }
        if (this.maritalStatusLayout.getVisibility() != 8) {
            user.setMaritalStatus(this.maritalStatus);
        }
        if (this.religionLayout.getVisibility() != 8) {
            user.setReligion(this.editTextReligion.getText().toString());
        }
        return user;
    }

    public boolean validateInputs() {
        Context context = this.editTextEmail.getContext();
        this.editTextFirstName.setError(null);
        this.editTextLastName.setError(null);
        this.editTextEmail.setError(null);
        this.editTextPassword.setError(null);
        this.editTextConfirmPassword.setError(null);
        this.editTextAddress.setError(null);
        this.editTextReligion.setError(null);
        this.editTextPhone.setError(null);
        String firstName = this.editTextFirstName.getText().toString().trim();
        String lastName = this.editTextLastName.getText().toString().trim();
        String email = this.editTextEmail.getText().toString().trim();
        String password = this.editTextPassword.getText().toString();
        String confirmPassword = this.editTextConfirmPassword.getText().toString();
        String religion = this.editTextReligion.getText().toString().trim();
        String address = this.editTextAddress.getText().toString().trim();
        String phone = this.editTextPhone.getText().toString().trim();
        boolean cancel = false;
        EditText focusView = null;
        if (TextUtils.isEmpty((CharSequence)firstName)) {
            this.editTextFirstName.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
            focusView = this.editTextFirstName;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)lastName)) {
            this.editTextLastName.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
            focusView = this.editTextLastName;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)password) || !Utility.isPasswordValid(password)) {
            this.editTextPassword.setError((CharSequence)context.getResources().getString(R.string.error_invalid_password));
            focusView = this.editTextPassword;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)confirmPassword) || !Utility.isPasswordValid(confirmPassword)) {
            this.editTextConfirmPassword.setError((CharSequence)context.getResources().getString(R.string.error_invalid_password));
            focusView = this.editTextConfirmPassword;
            cancel = true;
        }
        if (!password.equals(confirmPassword)) {
            this.editTextPassword.setError((CharSequence)context.getResources().getString(R.string.error_password_mismatch));
            focusView = this.editTextPassword;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)email)) {
            this.editTextEmail.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
            focusView = this.editTextEmail;
            cancel = true;
        } else if (this.validateEmail && !Utility.isEmailValid(email)) {
            this.editTextEmail.setError((CharSequence)context.getResources().getString(R.string.error_invalid_email));
            focusView = this.editTextEmail;
            cancel = true;
        }
        if (this.phoneLayout.getVisibility() != 8) {
            if (phone.isEmpty()) {
                this.editTextPhone.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
                focusView = this.editTextPhone;
                cancel = true;
            } else if (phone.length() != 11) {
                this.editTextPhone.setError((CharSequence)context.getResources().getString(R.string.error_phone_incomplete));
                focusView = this.editTextPhone;
                cancel = true;
            }
        }
        if (this.religionLayout.getVisibility() != 8 && TextUtils.isEmpty((CharSequence)religion)) {
            this.editTextReligion.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
            focusView = this.editTextReligion;
            cancel = true;
        }
        if (this.addressLayout.getVisibility() != 8 && TextUtils.isEmpty((CharSequence)address)) {
            this.editTextAddress.setError((CharSequence)context.getResources().getString(R.string.error_field_required));
            focusView = this.editTextAddress;
            cancel = true;
        }
        if (this.maritalStatusLayout.getVisibility() != 8 && this.maritalStatus.equals("Unknown")) {
            Toast toast = Toast.makeText((Context)context, (CharSequence)"Select Marital Status", (int)1);
            toast.setGravity(17, 0, 0);
            toast.show();
            cancel = true;
        }
        if (cancel) {
            if (focusView != null) {
                focusView.requestFocus();
            }
            return false;
        }
        return true;
    }

    public void showProgressBar(final boolean show) {
        int shortAnimTime = this.getResources().getInteger(0x10E0000);
        this.linearLayoutRegForm.setVisibility(show ? 8 : 0);
        this.linearLayoutRegForm.animate().setDuration((long)shortAnimTime).alpha(show ? 0.0f : 1.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                RegForm.this.linearLayoutRegForm.setVisibility(show ? 8 : 0);
            }
        });
        this.progressBar.setVisibility(show ? 0 : 8);
        this.progressBar.animate().setDuration((long)shortAnimTime).alpha(show ? 1.0f : 0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                RegForm.this.progressBar.setVisibility(show ? 0 : 8);
            }
        });
    }

    public void init(Activity activity) {
        this.registrationOnClickListener = (RegistrationOnClickListener)activity;
        this.textViewLogin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                RegForm.this.registrationOnClickListener.onSignInClick();
            }
        });
        this.buttonRegister.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                RegForm.this.registrationOnClickListener.onRegisterClick();
            }
        });
    }
}

