/*
 * Decompiled with CFR 0.152.
 */
package ng.shoppi.androidfrontend.forms;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import ng.shoppi.androidfrontend.R;
import ng.shoppi.androidfrontend.listeners.LoginOnClickListener;
import ng.shoppi.androidfrontend.models.User;
import ng.shoppi.androidfrontend.util.Utility;

public class LoginFormA
extends RelativeLayout {
    private ImageView backgroundImageView;
    private Button signInButton;
    private LinearLayout linearLayoutLoginForm;
    private ProgressBar progressBarSignIn;
    private ImageView imageView;
    private EditText editTextEmail;
    private EditText editTextPassword;
    private TextView signUpTextView;
    private LoginOnClickListener loginOnClickListener;
    private TextView forgotPasswordTextView;
    private boolean validateEmail;

    public LoginFormA(Context context) {
        super(context);
        this.initView(null);
    }

    public LoginFormA(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(attrs);
    }

    public LoginFormA(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(attrs);
    }

    public LoginFormA(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(attrs);
    }

    private void initView(@Nullable AttributeSet attributeSet) {
        View view = LoginFormA.inflate((Context)this.getContext(), (int)R.layout.lib_shopping_login_2, null);
        if (attributeSet == null) {
            this.addView(view);
            return;
        }
        this.backgroundImageView = (ImageView)view.findViewById(R.id.backgroundImage);
        this.imageView = (ImageView)view.findViewById(R.id.logo);
        this.editTextEmail = (EditText)view.findViewById(R.id.editTextEmail);
        this.editTextPassword = (EditText)view.findViewById(R.id.editTextPassword);
        this.forgotPasswordTextView = (TextView)view.findViewById(R.id.textViewForgotPassword);
        this.signInButton = (Button)view.findViewById(R.id.buttonLogin);
        this.signUpTextView = (TextView)view.findViewById(R.id.textViewSignUp);
        this.linearLayoutLoginForm = (LinearLayout)view.findViewById(R.id.linearLayoutLoginForm);
        this.progressBarSignIn = (ProgressBar)view.findViewById(R.id.progressBarSignIn);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.LoginFormA);
        Drawable backgroundDrawable = typedArray.getDrawable(R.styleable.LoginFormA_background_image);
        Drawable logoDrawable = typedArray.getDrawable(R.styleable.LoginFormA_logo);
        String userIdLabel = typedArray.getString(R.styleable.LoginFormA_user_id_label);
        String signInLabel = typedArray.getString(R.styleable.LoginFormA_sign_in_label);
        String signUpLabel = typedArray.getString(R.styleable.LoginFormA_sign_up_label);
        this.validateEmail = typedArray.getBoolean(R.styleable.LoginFormA_login_validate_email, true);
        if (userIdLabel != null && !userIdLabel.equals("")) {
            this.editTextEmail.setHint((CharSequence)userIdLabel);
        } else {
            this.editTextEmail.setHint((CharSequence)"Email");
        }
        if (signInLabel != null && !signInLabel.equals("")) {
            this.signInButton.setText((CharSequence)signInLabel);
        }
        if (signUpLabel != null && !signUpLabel.equals("")) {
            this.signUpTextView.setText((CharSequence)signUpLabel);
        }
        if (logoDrawable != null) {
            this.imageView.setImageDrawable(logoDrawable);
        }
        if (backgroundDrawable != null) {
            this.backgroundImageView.setImageDrawable(backgroundDrawable);
        }
        this.addView(view);
        typedArray.recycle();
    }

    public void init(Context context) {
        this.loginOnClickListener = (LoginOnClickListener)context;
        this.signInButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginFormA.this.loginOnClickListener.onSignInClick();
            }
        });
        this.signUpTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginFormA.this.loginOnClickListener.onSignUpClick();
            }
        });
        this.forgotPasswordTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginFormA.this.loginOnClickListener.onForgetPasswordClick();
            }
        });
    }

    public User getUser() {
        return new User(this.editTextEmail.getText().toString(), this.editTextPassword.getText().toString());
    }

    public boolean validateInput() {
        return Utility.validateInput(this.editTextEmail, this.editTextPassword, this.validateEmail);
    }

    public void showProgressBar(final boolean show) {
        int shortAnimTime = this.getResources().getInteger(0x10E0000);
        this.linearLayoutLoginForm.setVisibility(show ? 8 : 0);
        this.linearLayoutLoginForm.animate().setDuration((long)shortAnimTime).alpha(show ? 0.0f : 1.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                LoginFormA.this.linearLayoutLoginForm.setVisibility(show ? 8 : 0);
            }
        });
        this.progressBarSignIn.setVisibility(show ? 0 : 8);
        this.progressBarSignIn.animate().setDuration((long)shortAnimTime).alpha(show ? 1.0f : 0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                LoginFormA.this.progressBarSignIn.setVisibility(show ? 0 : 8);
            }
        });
    }
}

