/*
 * Decompiled with CFR 0.152.
 */
package nf.fr.eraasoft.pool.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import nf.fr.eraasoft.pool.PoolSettings;
import nf.fr.eraasoft.pool.impl.Controlable;

public class PoolControler
extends Thread {
    static PoolControler instance = null;
    boolean alive = false;
    Set<PoolSettings<?>> listPoolSettings = Collections.synchronizedSet(new HashSet());

    private PoolControler() {
        this.setName("PoolControler");
    }

    private static synchronized void launch() {
        if (instance == null) {
            instance = new PoolControler();
        }
        if (!PoolControler.instance.alive) {
            PoolControler.instance.alive = true;
            instance.start();
        }
    }

    public static synchronized void addPoolSettings(PoolSettings<?> poolSettings) {
        PoolControler.launch();
        PoolControler.instance.listPoolSettings.add(poolSettings);
    }

    public static void shutdown() {
        if (instance != null) {
            PoolControler.instance.alive = false;
            for (PoolSettings<?> poolSettings : PoolControler.instance.listPoolSettings) {
                if (!(poolSettings.pool() instanceof Controlable)) continue;
                Controlable controlable = (Controlable)((Object)poolSettings.pool());
                controlable.destroy();
            }
            PoolControler.instance.listPoolSettings.clear();
            instance.interrupt();
            instance = null;
        }
    }

    @Override
    public void run() {
        System.out.println("Starting " + this.getName());
        this.alive = true;
        while (this.alive) {
            try {
                PoolControler.sleep(PoolSettings.timeBetweenTwoControls() * 1000);
                this.checkPool();
            }
            catch (InterruptedException e) {
                System.out.println("PoolControler " + e.getMessage());
                this.alive = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPool() {
        Set<PoolSettings<?>> set = this.listPoolSettings;
        synchronized (set) {
            for (PoolSettings<?> poolSettings : this.listPoolSettings) {
                int idleToRemoves;
                if (!(poolSettings.pool() instanceof Controlable)) continue;
                Controlable controlable = (Controlable)((Object)poolSettings.pool());
                if (poolSettings.debug()) {
                    System.out.println(controlable.toString());
                }
                if ((idleToRemoves = controlable.idles() - poolSettings.maxIdle()) > 0) {
                    controlable.remove(idleToRemoves);
                }
                controlable.validateIdles();
            }
        }
    }
}

