/*
 * Decompiled with CFR 0.152.
 */
package com.nexuslink.textimageview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import java.util.Arrays;
import java.util.List;

public class TextImageView
extends AppCompatImageView {
    private Character character;
    private Paint backgroundPaint;
    private Paint textPaint;
    private List<String> colors;
    private int position;

    public TextImageView(Context context, int position) {
        this(context, null);
    }

    public TextImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.backgroundPaint = new Paint(1);
        this.textPaint = new Paint(1);
        this.colors = Arrays.asList("#F44336", "#E91E63", "#9C27B0", "#673AB7", "#3F51B5", "#009688", "#FF5722", "#795548", "#607D8B");
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.backgroundPaint.setColor(Color.parseColor((String)this.colors.get(this.position % this.colors.size())));
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)(this.getWidth() / 2), this.backgroundPaint);
        this.textPaint.setColor(-1);
        this.textPaint.setTextSize((float)(this.getWidth() / 2));
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        Paint.FontMetricsInt fontMetrics = this.textPaint.getFontMetricsInt();
        int baseline = (this.getMeasuredHeight() - fontMetrics.bottom - fontMetrics.top) / 2;
        canvas.drawText(this.getText().toString(), (float)(this.getWidth() / 2), (float)baseline, this.textPaint);
    }

    public void setText(String text) {
        this.character = Character.valueOf(text.charAt(0));
    }

    public Character getText() {
        if (this.character == null) {
            return Character.valueOf('N');
        }
        return this.character;
    }

    public void setMaterialDefaultColor(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }
}

