package com.nexuslink.textimageview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

import java.util.Arrays;
import java.util.List;

/**
 * Created by Rye on 2017/3/8.
 */

public class TextImageView extends android.support.v7.widget.AppCompatImageView {
    private Character character;
    private Paint backgroundPaint;
    private Paint textPaint;
    private List<String> colors;
    private int position;

    //让View兼容xml与Java
    public TextImageView(Context context, int position) {
        this(context,null);
    }

    public TextImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs,0);
    }

    public TextImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        backgroundPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        textPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        //默认颜色组为Material Design饱和度为500的非亮色背景
        colors = Arrays.asList("#F44336","#E91E63","#9C27B0","#673AB7","#3F51B5","#009688","#FF5722","#795548","#607D8B");
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        //绘制过程

        backgroundPaint.setColor(Color.parseColor(colors.get(position % colors.size())));
        canvas.drawCircle(getWidth() / 2, getWidth() / 2, getWidth() / 2, backgroundPaint);
        textPaint.setColor(Color.WHITE);
        textPaint.setTextSize(getWidth() / 2);
        textPaint.setTextAlign(Paint.Align.CENTER);
        Paint.FontMetricsInt fontMetrics = textPaint.getFontMetricsInt();
        int baseline = (getMeasuredHeight() - fontMetrics.bottom - fontMetrics.top) / 2;
        canvas.drawText(getText().toString(), getWidth() / 2, baseline, textPaint);
    }

     public void setText(String text){
         this.character = text.charAt(0);
     }

    public Character getText() {
        if(character == null){
            return 'N'; //未设置文字时文字为Null首字母
        }
        return character;
    }

    public void setMaterialDefaultColor(int position){
        this.position = position;
    }

    public int getPosition() {
        return position;
    }
}
