/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.repo;

import javax.annotation.Nonnull;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;
import network.minter.profile.api.ProfileAuthEndpoint;
import network.minter.profile.models.LoginData;
import network.minter.profile.models.ProfileRequestResult;
import network.minter.profile.models.ProfileResult;
import network.minter.profile.models.RegisterData;
import network.minter.profile.models.User;
import network.minter.profile.models.UsernameData;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ProfileAuthRepository
extends DataRepository<ProfileAuthEndpoint>
implements DataRepository.Configurator {
    public ProfileAuthRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public void configure(ApiService.Builder builder) {
        builder.authRequired(true);
    }

    @Nonnull
    protected Class<ProfileAuthEndpoint> getServiceClass() {
        return ProfileAuthEndpoint.class;
    }

    public Call<ProfileResult<User>> login(LoginData loginData) {
        return ((ProfileAuthEndpoint)this.getInstantService(builder -> builder.authRequired(false))).login(loginData);
    }

    public Call<ProfileResult<ProfileRequestResult>> register(RegisterData registerData) {
        ProfileAuthRepository profileAuthRepository = this;
        profileAuthRepository.login(null).enqueue((Callback)new Callback<ProfileResult<User>>(){

            public void onResponse(Call<ProfileResult<User>> call, Response<ProfileResult<User>> response) {
            }

            public void onFailure(Call<ProfileResult<User>> call, Throwable throwable) {
            }
        });
        return ((ProfileAuthEndpoint)profileAuthRepository.getInstantService(profileAuthRepository)).register(registerData);
    }

    public Call<ProfileResult<UsernameData>> checkUsernameAvailability(String string) {
        ProfileAuthRepository profileAuthRepository = this;
        return ((ProfileAuthEndpoint)profileAuthRepository.getInstantService(profileAuthRepository)).checkUsernameAvailability(string);
    }
}

