/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.models;

import network.minter.core.crypto.HashUtil;
import org.parceler.Parcel;

@Parcel
public class LoginData {
    public String username;
    public String password;
    public transient String rawPassword;

    public LoginData() {
    }

    private LoginData(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public LoginData preparePassword() {
        LoginData loginData = this;
        loginData.password = HashUtil.sha256HexDouble((String)loginData.rawPassword);
        return loginData;
    }

    public static final class Builder {
        private String username;
        private String password;

        private Builder() {
        }

        public Builder setUsername(String string) {
            this.username = string;
            return this;
        }

        public Builder setPassword(String string) {
            this.password = string;
            return this;
        }

        public LoginData build() {
            return new LoginData(this);
        }
    }
}

