/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile;

import com.google.gson.GsonBuilder;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.EncryptedString;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerDeserializer;
import network.minter.core.internal.api.converters.BytesDataDeserializer;
import network.minter.core.internal.api.converters.EncryptedStringDeserializer;
import network.minter.core.internal.api.converters.EncryptedStringSerializer;
import network.minter.core.internal.api.converters.MinterAddressDeserializer;
import network.minter.core.internal.api.converters.MinterAddressSerializer;
import network.minter.core.internal.common.Lazy;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.log.Mint;
import network.minter.core.internal.log.TimberLogger;
import network.minter.profile.repo.ProfileAddressRepository;
import network.minter.profile.repo.ProfileAuthRepository;
import network.minter.profile.repo.ProfileInfoRepository;
import network.minter.profile.repo.ProfileRepository;
import okhttp3.logging.HttpLoggingInterceptor;

public class MinterProfileApi {
    private static final String BASE_API_URL = "https://my.beta.minter.network";
    private static MinterProfileApi INSTANCE;
    private ApiService.Builder mApiService;
    private ProfileAuthRepository mAuthRepository;
    private ProfileInfoRepository mInfoRepository;
    private ProfileAddressRepository mAddressRepository;
    private ProfileRepository mProfileRepository;

    private MinterProfileApi(Lazy<String> lazy) {
        MinterProfileApi minterProfileApi = this;
        minterProfileApi.mApiService = new ApiService.Builder(BASE_API_URL, this.getGsonBuilder());
        minterProfileApi.mApiService.addHeader("Content-Type", "application/json");
        minterProfileApi.mApiService.addHeader("X-Minter-Client-Name", "MinterAndroid (profile)");
        minterProfileApi.mApiService.addHeader("X-Minter-Client-Version", "0.2.4");
        minterProfileApi.mApiService.setDateFormat("yyyy-MM-dd HH:mm:ssX");
        minterProfileApi.mApiService.setAuthHeaderName("Authorization");
        minterProfileApi.mApiService.setTokenGetter(() -> {
            if (lazy == null) {
                return null;
            }
            return "Bearer " + (String)lazy.get();
        });
    }

    public static void initialize(Lazy<String> timberLogger) {
        TimberLogger timberLogger2;
        TimberLogger timberLogger3 = timberLogger;
        timberLogger = timberLogger2;
        timberLogger2 = new TimberLogger();
        MinterProfileApi.initialize((Lazy<String>)timberLogger3, false, (Mint.Leaf)timberLogger);
    }

    public static void initialize(Lazy<String> lazy, boolean bl) {
        MinterProfileApi.initialize(lazy, bl, (Mint.Leaf)new TimberLogger());
    }

    public static void initialize(Lazy<String> builder, boolean bl, Mint.Leaf leaf) {
        if (INSTANCE != null) {
            return;
        }
        if (bl) {
            Mint.brew((Mint.Leaf)leaf);
        }
        INSTANCE = new MinterProfileApi((Lazy<String>)builder);
        MinterProfileApi.INSTANCE.mApiService.setDebug(bl);
        builder = MinterProfileApi.INSTANCE.mApiService;
        HttpLoggingInterceptor.Level level = bl ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE;
        builder.setDebugRequestLevel(level);
    }

    public static String getCoinAvatarUrl(@Nonnull String string) {
        String string2 = string;
        Preconditions.checkNotNull((Object)string2, (String)"Coin name can't be null");
        Preconditions.checkArgument((string2.length() >= 3 && string.length() <= 10 ? 1 : 0) != 0, (Object)"Coin length must be from 3 to 10 chars");
        return "https://my.beta.minter.network/api/v1/avatar/by/coin/" + string.toUpperCase();
    }

    public static String getUserAvatarUrl(long l) {
        return MinterProfileApi.getUserAvatarUrl(String.valueOf(l));
    }

    public static String getUserAvatarUrl(String string) {
        Preconditions.checkNotNull((Object)string, (String)"Id required");
        return "https://my.beta.minter.network/api/v1/avatar/by/user/" + string;
    }

    public static String getUserAvatarUrlByAddress(MinterAddress minterAddress) {
        return MinterProfileApi.getUserAvatarUrlByAddress(minterAddress.toString());
    }

    public static String getUserAvatarUrlByAddress(String string) {
        if (!string.startsWith("Mx")) {
            return MinterProfileApi.getUserAvatarUrl(1L);
        }
        Preconditions.checkNotNull((Object)string, (String)"address required");
        return "https://my.beta.minter.network/api/v1/avatar/by/address/" + string;
    }

    public static MinterProfileApi getInstance() {
        return INSTANCE;
    }

    public ApiService.Builder getApiService() {
        return this.mApiService;
    }

    public GsonBuilder getGsonBuilder() {
        EncryptedStringSerializer encryptedStringSerializer;
        EncryptedStringDeserializer encryptedStringDeserializer;
        BytesDataDeserializer bytesDataDeserializer;
        BigIntegerDeserializer bigIntegerDeserializer;
        MinterAddressSerializer minterAddressSerializer;
        MinterAddressDeserializer minterAddressDeserializer;
        GsonBuilder gsonBuilder = new GsonBuilder();
        MinterProfileApi minterProfileApi = minterAddressDeserializer;
        minterAddressDeserializer = new MinterAddressDeserializer();
        gsonBuilder.registerTypeAdapter(MinterAddress.class, (Object)minterProfileApi);
        minterProfileApi = minterAddressSerializer;
        minterAddressSerializer = new MinterAddressSerializer();
        gsonBuilder.registerTypeAdapter(MinterAddress.class, (Object)minterProfileApi);
        minterProfileApi = bigIntegerDeserializer;
        bigIntegerDeserializer = new BigIntegerDeserializer();
        gsonBuilder.registerTypeAdapter(BigInteger.class, (Object)minterProfileApi);
        minterProfileApi = bytesDataDeserializer;
        bytesDataDeserializer = new BytesDataDeserializer();
        gsonBuilder.registerTypeAdapter(BytesData.class, (Object)minterProfileApi);
        minterProfileApi = encryptedStringDeserializer;
        encryptedStringDeserializer = new EncryptedStringDeserializer();
        gsonBuilder.registerTypeAdapter(EncryptedString.class, (Object)minterProfileApi);
        minterProfileApi = encryptedStringSerializer;
        encryptedStringSerializer = new EncryptedStringSerializer();
        gsonBuilder.registerTypeAdapter(EncryptedString.class, (Object)minterProfileApi);
        return gsonBuilder;
    }

    public ProfileAuthRepository auth() {
        if (this.mAuthRepository == null) {
            this.mAuthRepository = new ProfileAuthRepository(this.mApiService);
        }
        return this.mAuthRepository;
    }

    public ProfileInfoRepository info() {
        if (this.mInfoRepository == null) {
            this.mInfoRepository = new ProfileInfoRepository(this.mApiService);
        }
        return this.mInfoRepository;
    }

    public ProfileAddressRepository address() {
        if (this.mAddressRepository == null) {
            this.mAddressRepository = new ProfileAddressRepository(this.mApiService);
        }
        return this.mAddressRepository;
    }

    public ProfileRepository profile() {
        if (this.mProfileRepository == null) {
            this.mProfileRepository = new ProfileRepository(this.mApiService);
        }
        return this.mProfileRepository;
    }
}

