/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.models;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import network.minter.core.crypto.EncryptedString;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.common.Preconditions;
import org.parceler.Parcel;

@Parcel
public class ProfileAddressData {
    public String id;
    public MinterAddress address;
    public boolean isMain;
    public boolean isServerSecured;
    public EncryptedString encrypted;

    public ProfileAddressData() {
    }

    public ProfileAddressData(MinterAddress address, boolean isMain, String seedPhrase, boolean isServerSecured, String encryptionKey) {
        this.address = (MinterAddress)Preconditions.checkNotNull((Object)address, (String)"Address required");
        this.isMain = isMain;
        this.isServerSecured = isServerSecured;
        try {
            this.encrypted = new EncryptedString((String)Preconditions.checkNotNull((Object)seedPhrase, (String)"Seed phrase required"), (String)Preconditions.checkNotNull((Object)encryptionKey, (String)"Encryption key required"));
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("Unable to encrypt data", e);
        }
    }
}

