/*
 * Decompiled with CFR 0.152.
 */
package network.minter.profile.repo;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import network.minter.profile.api.ProfileInfoEndpoint;
import network.minter.profile.models.AddressInfoResult;
import network.minter.profile.models.ProfileResult;
import network.minter.profile.models.User;
import retrofit2.Call;

public class ProfileInfoRepository
extends DataRepository<ProfileInfoEndpoint> {
    public ProfileInfoRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<ProfileResult<AddressInfoResult>> getAddressWithUserInfo(String address) {
        return ((ProfileInfoEndpoint)this.getInstantService()).getAddressWithUserInfo(address);
    }

    public Call<ProfileResult<AddressInfoResult>> getAddressWithUserInfo(MinterAddress address) {
        return this.getAddressWithUserInfo(address.toString());
    }

    public Call<ProfileResult<List<AddressInfoResult>>> getAddressesWithUserInfoByStrings(List<String> addresses) {
        return ((ProfileInfoEndpoint)this.getInstantService()).getAddressesWithUserInfo(addresses);
    }

    public Call<ProfileResult<List<AddressInfoResult>>> getAddressesWithUserInfo(List<MinterAddress> addresses) {
        ArrayList<String> out = new ArrayList<String>(addresses.size());
        for (MinterAddress address : addresses) {
            out.add(address.toString());
        }
        return this.getAddressesWithUserInfoByStrings(out);
    }

    public Call<ProfileResult<User.Data>> getUserInfoByUsername(String username) {
        return ((ProfileInfoEndpoint)this.getInstantService()).getUserInfoByUsername(username);
    }

    public Call<ProfileResult<User.Data>> getUserInfoByUser(User user) {
        return this.getUserInfoByUser(user.data);
    }

    public Call<ProfileResult<User.Data>> getUserInfoByUser(User.Data userData) {
        return this.getUserInfoByUsername(userData.username);
    }

    public Call<ProfileResult<AddressInfoResult>> findAddressInfoByInput(@Nonnull String input) {
        Preconditions.checkNotNull((Object)input, (String)"Input can't be null");
        Preconditions.checkArgument((!input.isEmpty() ? 1 : 0) != 0, (Object)"Input can't be empty string");
        Preconditions.checkArgument((input.length() >= 2 ? 1 : 0) != 0, (Object)"Input length must have length more than 2 characters");
        if (input.substring(0, 2).equals("Mx") && input.length() == 42) {
            return this.getAddressWithUserInfo(input);
        }
        if (input.substring(0, 1).equals("@")) {
            return ((ProfileInfoEndpoint)this.getInstantService()).findAddressByUsername(input.substring(1));
        }
        return ((ProfileInfoEndpoint)this.getInstantService()).findAddressByEmail(input);
    }

    @Nonnull
    protected Class<ProfileInfoEndpoint> getServiceClass() {
        return ProfileInfoEndpoint.class;
    }
}

